<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sri Lanka’s First Digital Exam & Exam Practice Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.4/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="common.css">
    <link rel="icon" type="image/png" href="Resources/Logo/icon.png">
    <style>
        /* ===== About Us Page Styles ===== */
        .about-section {
            background: linear-gradient(135deg, #fdfbfb 0%, #ebedee 100%);
            padding: 140px 0;

        }

        .about-container {

            margin: 0 auto;
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: wrap;
            gap: 40px;
            padding: 0 20px;
        }



        .about-text h2 {

            color: var(--black);
            font-weight: 700;
            margin-bottom: 20px;
        }

        .about-text h2 span {
            color: var(--secondary);
        }

        .about-text p {
            font-size: 16px;
            color: #555;
            line-height: 1.8;
            margin-bottom: 15px;
        }

        .about-text .highlight {
            color: var(--secondary);
            font-weight: 600;
        }

        .about-image {

            text-align: center;
        }

        .about-image img {
            width: 100%;
            max-width: 420px;
            border-radius: 16px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }

        .about-image img:hover {
            transform: scale(1.05);
        }

        /* --- Mission & Vision Section --- */
        .mission-vision {
            background: #fff;
            padding: 60px 20px;
            display: flex;
            flex-wrap: wrap;
            gap: 30px;
            justify-content: center;
        }

        .mv-card {
            background: #f8f8f8;
            border-radius: 12px;
            padding: 30px;
            max-width: 450px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
            text-align: center;
            transition: all 0.3s ease;
        }

        .mv-card:hover {
            background: #fff;
            box-shadow: 0 6px 25px rgba(0, 0, 0, 0.08);
        }

        .mv-card h3 {
            color: var(--secondary);
            margin-bottom: 15px;
            font-size: 22px;
            font-weight: 700;
        }

        .mv-card p {
            color: #555;
            font-size: 15px;
            line-height: 1.8;
        }

        /* --- Responsive --- */
        @media (max-width: 768px) {
            .about-container {
                flex-direction: column;
                text-align: center;
            }

            .about-text h2 {
                font-size: 30px;
            }

            .about-text p {
                font-size: 15px;
            }
        }

        @media (max-width: 992px) {
            .about-container {
                flex-direction: column;
                text-align: center;
            }

            .about-text h2 {
                font-size: 30px;
            }

            .about-text p {
                font-size: 15px;
            }
        }
    </style>
</head>

<body style="overflow-x: hidden;">

    <?php include 'Navbar.php'; ?>

    <!-- ===== ABOUT SECTION ===== -->
    <section class="about-section">
        <div class="about-container container">
            <div class="about-text col-lg-6" data-aos="zoom-in">
                <h2>About <span>Us</span></h2>

                <p style="text-align: justify;">At <span class="fw-bold">Eexam.lk</span>, we believe in preparing students for the future of education through technology-driven solutions. As Sri Lanka’s First <span class="fw-bold">Digital Exam & Exam Practice Platform,</span> our mission is to make exam preparation smarter, easier, and stress-free.

                </p>

                <p style="text-align: justify;">We provide students with <span class="fw-bold">computer-based mock exams</span> that mirror real examination conditions, helping them to gain confidence and overcome exam anxiety. Our platform is designed to support learners of all levels with accessible practice tests, instant feedback, and user-friendly features that can be used anytime, anywhere.</p>
            </div>
            <!-- Move image div to the end -->
            <div class="about-image " data-aos="zoom-in">
                <img src="Resources/Images/AboutUS.jpg" alt="About Us Image">
            </div>
        </div>
    </section>

    <!-- ===== MISSION & VISION ===== -->
    <section class="mission-vision">
        <div class="mv-card" data-aos="zoom-in">
            <h3>Our Mission</h3>
            <p>To empower Sri Lankan students by providing the premier digital platform for <span class="fw-bold">computer-based mock exams.</span> We are committed to transforming traditional exam preparation into a streamlined, smart, and <span class="fw-bold">stress-free</span> experience, accessible to all learners.</p>
        </div>
        <div class="mv-card" data-aos="zoom-in">
            <h3>Our Vision</h3>
            <p>To be the <span class="fw-bold">definitive national standard</span> for digital assessment and exam preparedness in Sri Lanka, fostering a generation of confident, digitally-ready students equipped to excel in both local and global educational environments.</p>
        </div>
    </section>



    <?php include 'Footer.php'; ?>

    <script src="https://unpkg.com/aos@2.3.4/dist/aos.js"></script>
    <script>
        AOS.init({
            duration: 800, // animation duration (ms)
            once: true // run animation only once
        });
    </script>
</body>

</html>