<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sri Lanka’s First Digital Exam & Exam Practice Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://unpkg.com/aos@2.3.4/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="common.css">
    <link rel="icon" type="image/png" href="Resources/Logo/icon.png">

    <style>
        .left-section {
            background: url("Resources/Images/login-image.jpg") center/cover no-repeat;
            position: relative;
            min-height: 100vh;
        }

        .left-section::before {
            content: "";
            position: absolute;
            inset: 0;
            background: rgba(0, 0, 0, 0.5);
        }

        .left-text {
            position: relative;
            z-index: 2;
            margin-top: 310px;
        }

        .left-section h1 {
            font-weight: 700;
            font-size: 40px;
        }

        @media (max-width: 1140px) {
            .left-section h1 {
                font-size: 30px;
            }
        }

        .left-section .highlight {
            color: var(--primary);
        }

        .right-section {
            background: #fff;
            border-left: 8px solid var(--primary);
            min-height: 100vh;
            position: relative;
        }


        .contact-info {
            position: absolute;
            top: 15px;
            right: 30px;
            font-size: 0.9rem;
            color: var(--gray);
        }

        .login-form h3 {
            font-weight: 700;
            color: var(--secondary);
        }

        .form-control {
            border-radius: 8px;
            padding: 10px 14px;
        }

        .toggle-password {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: var(--secondary);
        }



        .login-btn {
            height: 50px;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            border: none;
            border-radius: 8px;
            font-weight: 600;
            color: var(--light);
        }

        .login-btn:hover {
            background: linear-gradient(135deg, var(--secondary), var(--primary));
            color: var(--light);
            transform: translateY(-3px);
            transition: all 0.3s;
        }

        .login-link {
            color: var(--primary);
            font-weight: 500;
            text-decoration: none;
        }

        .login-link:hover {
            text-decoration: underline;
        }

        @media (max-width: 991px) {
            .left-section {
                display: none;
            }

            .right-section {
                border: none;
            }
        }
    </style>
</head>

<body style="overflow-x: hidden;">

    <div class="container-fluid min-vh-100">
        <div class="row h-100">

            <!-- Left Section -->
            <div class="col-lg-6 d-none d-lg-flex align-items-center justify-content-center left-section">

               <div class="text-white text-center px-4 left-text " data-aos="fade-right">
                    <h1>Welcome to <span style="color: var(--secondary);"><img src="Resources/Logo/Logo.png" class="mb-2" style="height: 50px;"></span></h1>
                    <p class="text-start">Transforms lives through education</p>
                </div>
            </div>

            <!-- Right Section -->
            <div class="col-lg-6 d-flex flex-column justify-content-center px-5 py-4 right-section">

            

                <!-- Login Form -->
                <div class="login-form mt-5">
                    <div>
                        <div class="row col-md-8 col-12 col-lg-10 col-xl-8 g-3 mx-auto mt-5 " data-aos="fade-up">
                            <div class="container">
                                <h3 class="mb-2">Admin Login</h3>
                                <p class="text-muted mb-4">Enter your credentials to continue</p>
                            </div>

                            <!-- NIC -->
                            <div class="mt-2">
                                <label for="form-label" class="mb-1 fw-bold">Email Address</label>
                                <input id="email" type="text" class="form-control " placeholder="emily.johnson@gmail.com">
                            </div>

                            <!-- Password -->
                            <div class="mt-3 position-relative">
                                <label for="form-label" class="mb-1 fw-bold">Password</label>
                                <input id="password" type="password" class="form-control" id="password" placeholder="Em!lyJ#2024">
                                <i class="fa-solid fa-eye toggle-password me-3 mt-3" id="togglePassword"></i>
                            </div>



                            <!-- Button -->
                            <div class="d-grid">
                                <button onclick="AdminLogin();" class="btn login-btn mt-4">
                                    <img class="me-2" src="Resources/Icons/login.png" style="height: 30px;">Login to Dashboard
                                </button>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <script src="common.js"></script>
    <script src="Backend/Js/AdminLogin.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://unpkg.com/aos@2.3.4/dist/aos.js"></script>
    <script>
        AOS.init({
            duration: 800,
            once: true,
            offset: 80,
        });
    </script>
</body>

</html>