
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Navbar - Online Akura</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="common.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <style>
        .login-btn {
            height: 40px;
            width: 120px;
            background: linear-gradient(135deg, var(--primary), #f43f3f);
            color: #fff;
            font-weight: 700;
            border-radius: 6px;
            border: none;
            transition: 0.3s;
        }

        .login-btn:hover {
            background: linear-gradient(135deg, #b71c1c, var(--primary));
        }

        .navbar-nav .nav-link {
            font-weight: 700;
            margin: 0 10px;
            color: var(--black);
            transition: color 0.3s;
        }

        .navbar-nav .nav-link.active {
            color: var(--primary) !important;
            font-weight: 700;

        }

        .navbar-nav .nav-link:hover {
            color: var(--secondary);
        }

        .icon-bg {
            background: #fff !important;
            padding: 8px;
            border-radius: 6px;
        }

        /* Hover effect for overlay links */
        #profileOverlay a:hover,
        #desktopProfileOverlay a:hover {
            background: rgba(244, 63, 63, 0.1);
            color: var(--secondary) !important;
            text-decoration: none;
            transition: 0.3s ease;
        }

        /* --- Profile Modal Form Styling --- */
        #profileModal .form-control {
            border-radius: 8px;
            height: 45px;
            padding: 10px 15px;
            font-size: 15px;
        }

        #profileModal .row.g-3 {
            gap: 0 !important;
        }

        #profileModal .col-md-5,
        #profileModal .mb-3,
        #profileModal .input-group {
            margin-bottom: 15px !important;
        }

        #profileModal form {
            max-width: 450px;
            margin: auto;
        }

        /* Save Details Button Styling */
        .save-btn {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            border: none;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .save-btn:hover {
            background: linear-gradient(135deg, var(--secondary), var(--primary));
            transform: translateY(-3px);
            box-shadow: 0 4px 10px rgba(244, 63, 63, 0.3);
        }

     #mobileProfile img {
            width: 100% !important;
            height: 100% !important;
            object-fit: cover !important;
            object-position: center !important;
            display: block !important;
        }

         @media (max-width: 576px) {

        /* Reduce logo size */
        nav img {
            height: 28px !important;
        }

        /* Make Login button smaller */
        .login-btn {
            height: 32px !important;
            width: 90px !important;
            font-size: 13px !important;
        }

        /* Make toggle (hamburger) icon smaller */
        .fa-bars {
            font-size: 1.5rem !important;
        }

        /* Adjust profile picture small size */
        #mobileProfile {
            width: 38px !important;
            height: 38px !important;
        }

        /* Reduce greeting text size */
        .fw-bold {
            font-size: 15px !important;
        }

        /* Reduce navbar padding */
        
        /* Prevent modal title from shrinking on small screens */
        #profileModalLabel {
            font-size: 1.6rem !important;
        }
    }
    </style>
</head>

<body>

    <!-- Navbar -->
    <div class="fixed-top">
        <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm ">
            <div class="container">
                <a href="adminPanel.php"><img src="Resources/Logo/logo.png" style="height: 40px;"></a>

                <div class="ms-auto d-lg-none d-block me-4 d-none">
                    <a href="login.php"><button class="login-btn">Log in</button></a>
                </div>

                <!-- Mobile Screen -->
                <div class="d-flex d-lg-none align-items-center ms-auto me-2 position-relative">
                    <div class="d-block">
                        <div class="d-flex align-items-center justify-content-center">
                            <h5 class="fw-bold mb-0 me-1 mt-2">
                                <?php
                                if (isset($_SESSION["admin"])) {
                                    $data = $_SESSION["admin"];
                                ?>
                                    <span style="color:var(--secondary);">Admin,</span>
                                    <span style="color:var(--black);"><?php echo $data["fname"]; ?></span>
                                <?php
                                } else {
                                ?>
                                    <a style="text-decoration: none;" href="AdminLogin.php"> <button class="login-btn d-block">Log in</button> </a>
                                <?php
                                }
                                ?>
                            </h5>

                            <?php
                            if (isset($_SESSION["admin"])) {
                            ?>
                                <div id="mobileProfile" style="width:45px;height:45px;border-radius:8px;overflow:hidden;
                                    background:linear-gradient(135deg,#f43f3f,var(--primary));
                                    color:#fff;font-weight:700;
                                    display:flex;align-items:center;justify-content:center;
                                    font-size:22px;margin-left:10px;cursor:pointer;">
                                    <img src="<?php echo isset($_SESSION['admin']['profile_img']) && !empty($_SESSION['admin']['profile_img']) ? $_SESSION['admin']['profile_img'] : 'Resources/Images/Profile.jpg'; ?>" 
                                         alt="Profile" 
                                         style="width:100%;height:100%;object-fit:cover;display:block;margin:0;padding:0;border:none;border-radius:0;">
                                </div>
                            <?php
                            }
                            ?>
                        </div>

                        <div id="profileOverlay" style="display:none; position:absolute; top:50px; right:0; background:white; box-shadow:0 4px 10px rgba(0,0,0,0.15); border-radius:8px; padding:10px 0; width:150px; z-index:1000;">
                            <a href="#" data-bs-toggle="modal" data-bs-target="#profileModal" style="display:block; padding:8px 15px; color:var(--black); text-decoration:none; font-weight:600;">View Profile</a>
                            <a onclick="AdminSignOut();" style="display:block; padding:8px 15px; color:var(--black); text-decoration:none; font-weight:600;">Sign out</a>
                        </div>
                    </div>
                </div>
                <!-- Mobile Screen -->

                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        const profileBtn = document.getElementById('mobileProfile');
                        const overlay = document.getElementById('profileOverlay');

                        profileBtn.addEventListener('click', function(e) {
                            e.stopPropagation();
                            overlay.style.display = (overlay.style.display === 'block') ? 'none' : 'block';
                        });

                        document.addEventListener('click', function() {
                            overlay.style.display = 'none';
                        });
                    });
                </script>

                <button class=" d-block d-lg-none border-0 icon-bg mt-2" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                    <span><i class="fa-solid fa-bars fa-2x"></i></span>
                </button>

                <div class="collapse navbar-collapse justify-content-center" id="navbarNav">
                    <ul class="navbar-nav me-3 d-block d-lg-none">
                        <li class="nav-item">
                            <a class="nav-link active" href="#" data-target="dashboard">Admin Dashboard</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" data-target="subjects">Add Subjects</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" data-target="quiz">Add Quiz</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" data-target="access">Access</a>
                        </li>
                    </ul>
                </div>

                <div class="d-none d-lg-flex flex-column align-items-center position-relative">
                    <a href="login.php"> <button class="login-btn d-none">Log in</button> </a>

                    <!-- Greeting box under login button -->
                    <div class="d-flex align-items-center justify-content-center">
                        <h5 class="fw-bold mb-0 me-3">
                             <?php

                                if (isset($_SESSION["admin"])) {
                                    $data = $_SESSION["admin"];
                                ?>
                                    <span style="color:var(--secondary);">Admin,</span>
                                    <span style="color:var(--black);"><?php echo $data["fname"]; ?></span>


                                <?php
                                } else {
                                ?>
                                    <a style="text-decoration: none;" href="AdminLogin.php"> <button class="login-btn d-block">Log in</button> </a>

                                <?php
                                }
                                ?>

                            </h5>
                            
                            <?php
                            if (isset($_SESSION["admin"])) {
                            ?>
                                <div id="desktopProfile" style="width:45px;height:45px;border-radius:8px;overflow:hidden;
                                    background:linear-gradient(135deg,#f43f3f,var(--primary));
                                    color:#fff;font-weight:700;
                                    display:flex;align-items:center;justify-content:center;
                                    font-size:22px;margin-left:10px;cursor:pointer;">
                                    <img src="<?php echo isset($_SESSION['admin']['profile_img']) && !empty($_SESSION['admin']['profile_img']) ? $_SESSION['admin']['profile_img'] : 'Resources/Images/Profile.jpg'; ?>" alt="Profile" style="width:100%;height:100%;object-fit:cover;">
                                        
                                </div>
                            <?php
                            }
                            ?>

                        </h5>

                  
                    </div>

                    <!-- Overlay menu -->
                    <div id="desktopProfileOverlay" style="display:none; position:absolute; top:50px; right:0; background:white; box-shadow:0 4px 10px rgba(0,0,0,0.15); border-radius:8px; padding:10px 0; width:150px; z-index:1000;">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#profileModal" style="display:block; padding:8px 15px; color:var(--black); text-decoration:none; font-weight:600;">View Profile</a>
                        <a onclick="AdminSignOut();" style="display:block; padding:8px 15px; color:var(--black); text-decoration:none; font-weight:600;">Sign out</a>
                    </div>
                </div>

            </div>
        </nav>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="Backend/Js/SignOut.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="Backend/Js/AdminProfile.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const desktopProfileBtn = document.getElementById('desktopProfile');
            const desktopOverlay = document.getElementById('desktopProfileOverlay');

            desktopProfileBtn.addEventListener('click', function(e) {
                e.stopPropagation();
                desktopOverlay.style.display = (desktopOverlay.style.display === 'block') ? 'none' : 'block';
            });

            document.addEventListener('click', function() {
                desktopOverlay.style.display = 'none';
            });
        });
    </script>

    <!-- Profile Modal -->
    <div class="modal fade" id="profileModal" tabindex="-1" aria-labelledby="profileModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow-lg rounded-4 p-4" style="max-width:600px; margin:auto;">
                <div class="modal-header border-0">
                    <h4 class="modal-title w-100 text-center fw-bold" id="profileModalLabel" style="color:#f43f3f;">Admin Profile</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center">
                    <!-- Profile Picture Upload -->
                    <div class="position-relative d-inline-block mb-3">
                        <img id="profileImagePreview" src="Resources/Images/Profile.jpg" class="rounded-4" style="width:160px; height:160px; object-fit:cover; cursor:pointer;" alt="Profile Picture">

                        <!-- Overlay background -->
                        <div id="profileOverlayText" class="position-absolute top-50 start-50 translate-middle text-white fw-bold d-flex flex-column align-items-center justify-content-center"
                            style="opacity:0; transition:opacity 0.3s ease; background:rgba(0,0,0,0.5); width:100%; height:100%; border-radius:8px;">
                            <button id="choosePicBtn" class="btn btn-sm fw-bold text-white" style="background:#f43f3f; border:none; border-radius:6px; padding:5px 12px;">Choose Picture</button>
                        </div>

                        <input type="file" id="profileImageInput" accept="image/*" style="display:none;">
                    </div>

                    <form class="text-center">
                        <div class="row g-3 justify-content-center mb-3">
                            <div class="col-md-6">
                                <input id="adminFname" type="text" class="form-control" placeholder="First Name">
                            </div>
                            <div class="col-md-6">
                                <input id="adminLname" type="text" class="form-control" placeholder="Last Name">
                            </div>
                        </div>

                        <div class="mb-3">
                            <input id="adminEmail" type="email" class="form-control" placeholder="Email Address">
                        </div>

                        <div class="mt-3 position-relative mb-4 w-100" style=" margin:auto;">
                            <input id="adminPassword" type="password" class="form-control" placeholder="Password">
                            <i class="fa-solid fa-eye toggle-password me-3" id="togglePassword" style="position:absolute; right:10px; top:50%; transform:translateY(-50%); cursor:pointer; color:#f43f3f;"></i>
                        </div>

                       
                        


                        <button type="button" class="btn save-btn w-100 py-2 fw-bold text-white" onclick="updateAdminProfile()">
                            <i class="fa-solid fa-floppy-disk me-2"></i>Save Details
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script>
        // Toggle password visibility (Correct logic + correct icon switching)
        document.addEventListener('DOMContentLoaded', () => {
            const togglePassword = document.getElementById('togglePassword');
            const passwordInput = document.getElementById('adminPassword');

            if (togglePassword && passwordInput) {

                // Initial state: password hidden → show eye-slash
                togglePassword.classList.remove('fa-eye');
                togglePassword.classList.add('fa-eye-slash');

                togglePassword.addEventListener('click', function () {
                    const isHidden = passwordInput.type === 'password';
                    passwordInput.type = isHidden ? 'text' : 'password';

                    if (isHidden) {
                        // Password is now visible → show eye icon
                        this.classList.remove('fa-eye-slash');
                        this.classList.add('fa-eye');
                    } else {
                        // Password is hidden again → show eye-slash
                        this.classList.remove('fa-eye');
                        this.classList.add('fa-eye-slash');
                    }
                });
            }
        });
    </script>

</body>

</html>
    <script>
    document.addEventListener("DOMContentLoaded", () => {
        const navLinks = document.querySelectorAll(".navbar-nav .nav-link[data-target]");
        const adminTabs = window.parent?.document.querySelectorAll(".admin-tab");
        const adminPanels = {
            dashboard: window.parent?.document.getElementById("adminDashboardPanel"),
            subjects: window.parent?.document.getElementById("addSubjectsPanel"),
            quiz: window.parent?.document.getElementById("addQuizPanel"),
            access: window.parent?.document.getElementById("addAccessPanel")
        };

        navLinks.forEach(link => {
            link.addEventListener("click", (e) => {
                e.preventDefault();
                const target = link.getAttribute("data-target");

                // Close navbar dropdown when a link is clicked (mobile)
                const navbarCollapse = document.getElementById('navbarNav');
                const bsCollapse = bootstrap.Collapse.getInstance(navbarCollapse);
                if (bsCollapse && navbarCollapse.classList.contains('show')) {
                    bsCollapse.hide();
                }

                // Update nav active state
                navLinks.forEach(l => l.classList.remove("active"));
                link.classList.add("active");

                // Update adminTabs active state
                adminTabs?.forEach(tab => tab.classList.remove("active"));
                const matchingTab = [...(adminTabs||[])].find(t => t.dataset.target === target);
                matchingTab?.classList.add("active");

                // Hide all panels
                Object.values(adminPanels).forEach(p => p && (p.style.display = "none"));

                // Show selected panel
                if (adminPanels[target]) adminPanels[target].style.display = "block";
            });
        });
    });
    </script>