async function AdminLogin(){
    const email = document.getElementById("email").value;
    const password = document.getElementById("password").value;

    const loginData = {
        email: email,
        password: password,
    };


    const loginJSON = JSON.stringify(loginData);

    const response = await fetch(
        "Backend/Process/AdminLoginProcess.php", {
        method: "POST",
        body: loginJSON,
        headers: {
            "Content-type": "application/json"
        }
    }
    );

    if (response.ok) {
        const json = await response.json();
        console.log(json);

        if (json.status) {

            Swal.fire({
                title: json.message,
                icon: "success",
                draggable: true
            }).then(() => {
                
                window.location = "adminPanel.php";
            });
        } else {
            alert(json.message)
        }

    } else {
        alert("something went wrong")
    }

}