async function loadRequests() {
    try {
        // Get search text from Access Panel search input
        const searchInput = document.getElementById("accessSearch");
        const searchText = searchInput ? searchInput.value.trim() : "";
        
        const res = await fetch("Backend/Process/load_requests.php", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ text: searchText })
        });
        const data = await res.json();

        const tbody = document.getElementById("tbody");
        const noContent = document.querySelector(".no-content");

        tbody.innerHTML = ""; // clear table

        if ((data.status === true || data.status === "true") && Array.isArray(data.data) && data.data.length > 0) {
            noContent.style.display = "none";
            data.data.forEach(req => {
                const row = document.createElement("tr");
                row.style.backgroundColor = "#eaf4fb";

                row.innerHTML = `
                    <td>${req.firstName}</td>
                    <td>${req.nic}</td>
                    <td>${req.mobile}</td>
                    <td>${req.email}</td>
                    <td>
                        <span class="badge rounded-pill text-white px-3 py-2"
                              style="background:linear-gradient(90deg,#a86bfa,#d083ff); font-weight:600;">
                            ${req.subject}
                        </span>
                    </td>
                    <td>
                        <button class=" success-btn btn-sm px-3 fw-semibold accept-btn" data-id="${req.request_id}">Accept</button>
                        <button class="btn btn-danger btn-sm px-3 fw-semibold delete-btn" data-id="${req.request_id}">Delete</button>
                    </td>
                `;
                tbody.appendChild(row);
            });

            // ✅ Attach event listeners
            document.querySelectorAll(".accept-btn").forEach(btn => {
                btn.addEventListener("click", () => updateRequestStatus(btn.dataset.id, 2)); // 2 = accepted
            });

            document.querySelectorAll(".delete-btn").forEach(btn => {
                btn.addEventListener("click", () => updateRequestStatus(btn.dataset.id, 3)); // 3 = deleted
            });
        } else {
            noContent.style.display = "block";
        }
    } catch (error) {
        console.error("Error loading requests:", error);
    }
}

async function updateRequestStatus(request_id, status_id) {
    try {
        const res = await fetch("Backend/Process/update_request_status.php", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ request_id, status_id })
        });
        const data = await res.json();

        if (data.status) {
            Swal.fire("Success", data.message, "success");
            loadRequests(); // reload table
        } else {
            Swal.fire("Error", data.message, "error");
        }
    } catch (err) {
        Swal.fire("Error", "Failed to update request status", "error");
    }
}

document.addEventListener("DOMContentLoaded", loadRequests);
