async function signIn(event) {
    if (event) event.preventDefault(); // stop form submit

    const email = document.getElementById("email").value;
    const password = document.getElementById("password").value;
    const remember = document.getElementById("remember").checked;

    const data = { email, password, remember };

    const response = await fetch("Backend/Process/SignInProcess.php", {
        method: "POST",
        body: JSON.stringify(data),
        headers: { "Content-Type": "application/json" }
    });

    const json = await response.json();
    console.log(json);

    if (json.status) {
        Swal.fire({ title: json.message, icon: "success" })
        .then(() => window.location = "Dashboard.php");
    } else {
        Swal.fire({ title: json.message, icon: "warning" });
    }
}



document.addEventListener("DOMContentLoaded", async function () {
    const emailInput = document.getElementById("email");
    const passwordInput = document.getElementById("password");
    const rememberCheckbox = document.getElementById("remember");

    if (!emailInput || !passwordInput || !rememberCheckbox) return;

    try {
        const res = await fetch("Backend/Process/ValidateTokenProcess.php");
        const json = await res.json();
        console.log("TOKEN CHECK:", json);

        if (json.status && json.user) {
            emailInput.value = json.user.email;
            passwordInput.value = json.user.password;
            rememberCheckbox.checked = true;
        } else {
            // remove invalid token cookie
            document.cookie = "auth_token=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
        }
    } catch (err) {
        console.error("Token validation failed:", err);
    }
});
