async function AdminSignOut() {
    try {
        const response = await fetch("Backend/Process/AdminSignOutProcess.php", {
            method: "GET",
            headers: {
                "Content-Type": "application/json"
            }
        });

        if (response.ok) {
            const json = await response.json();
            console.log(json);

            if (json.status) {

                alert(json.message);
                window.location = "AdminLogin.php";
            } else {
                alert(json.message);
            }

        } else {
            alert("something went wrong")
        }
    } catch (error) {
        console.error("Sign out error:", error);
        alert("Something went wrong during sign out.");
    }
}

async function signOut() {

    const response = await fetch("Backend/Process/SignOutProcess.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" }
    });

    const json = await response.json();

    if (json.status) {
        Swal.fire({
            title: json.message,
            icon: "success"
        }).then(() => {
            window.location = "login.php";
        });
    } else {
        Swal.fire({
            title: json.message,
            icon: "error"
        });
    }
}
