async function SignUp(){

    const fname = document.getElementById("fname").value;
    const lname = document.getElementById("lname").value;
    const email = document.getElementById("email").value;
    const nic = document.getElementById("nic").value;
    const mobile = document.getElementById("mobile").value;
    const password = document.getElementById("password").value;

    const userObject = {
        fname:fname,
        lname:lname,
        email:email,
        nic:nic,
        mobile:mobile,
        password:password,
    };

    const userJSON = JSON.stringify(userObject);

    const response = await fetch(

        "Backend/Process/SignUpProcess.php",{
            method:"POST",
            body:userJSON,
            headers:{
                "Content-type": "application/json"
            }

        }
    );

    if (response.ok) {
            const json = await response.json(); 
            if (json.status) {
                alert(json.message);
                clearFields();
                window.location = "login.php";
                
            } else {
                alert(json.message);
            }
    } else {
        alert("Server error: " + response.status);
    }

}

function clearFields() {
  document.getElementById("fname").value = "";
  document.getElementById("lname").value = "";
  document.getElementById("email").value = "";
  document.getElementById("nic").value = "";
  document.getElementById("mobile").value = "";
  document.getElementById("password").value = "";
}