<?php
include "connection.php";
include "validation.php";

$json = file_get_contents("php://input");
$data = json_decode($json, true);

$lesson_id = $data["lesson"];
$question = $data["question"];
$option_A = $data["option_A"];
$option_B = $data["option_B"];
$option_C = $data["option_C"];
$option_D = $data["option_D"];
$medium = $data["medium"];
$answer = $data["answer"];
$quiz_number = $data["quiz_number"];

$response = [
    "status" => false,
    "message" => ""
];

if ($lesson_id == 0) {
    $response["message"] = "Please Select Lesson";
} else if (empty($question)) {
    $response["message"] = "Please Enter Question";
} else if (empty($option_A)) {
    $response["message"] = "Please Enter Option A";
} else if (empty($option_B)) {
    $response["message"] = "Please Enter Option B";
} else if (empty($option_C)) {
    $response["message"] = "Please Enter Option C";
} else if (empty($option_D)) {
    $response["message"] = "Please Enter Option D";
} else if ($medium == 0) {
    $response["message"] = "Please Select Medium";
} else if ($answer == 0) {
    $response["message"] = "Please Select Correct Answer";
} else {

    $d = new DateTime();
    $tz = new DateTimeZone("Asia/Colombo");
    $d->setTimezone($tz);
    $date = $d->format("Y-m-d H:i:s");

    try {

        $check_rs = Database::search("SELECT * FROM `mcq` WHERE `lesson_id` = '" . $lesson_id . "' AND `medium_id` = '" . $medium . "' AND `question_number` = '" . $quiz_number . "' ");

        if ($check_rs->num_rows > 0) {

            Database::iud("UPDATE `mcq` SET `question` = '" . $question . "', `option_a` = '" . $option_A . "', `option_b` = '" . $option_B . "',`option_c` = '" . $option_C . "',`option_d` = '" . $option_D . "',
            `correct_option` = '" . $answer . "' WHERE `lesson_id` = '" . $lesson_id . "' AND `medium_id` = '" . $medium . "' AND `question_number` = '" . $quiz_number . "' ");

            $response["status"] = true;
            $response["message"] = "Quiz updated successfully!";
        } else {

            $rs = Database::search("SELECT MIN(t1.question_number + 1) AS next_number FROM mcq t1
                WHERE NOT EXISTS (
                    SELECT 1 
                    FROM mcq t2
                    WHERE t2.question_number = t1.question_number + 1
                    AND t2.lesson_id = t1.lesson_id
                    AND t2.medium_id = t1.medium_id
                )AND t1.lesson_id = '" . $lesson_id . "' AND t1.medium_id = '" . $medium . "'");
                
    
            $data = $rs->fetch_assoc();
            $next_question_number = $data["next_number"] ?? 1;

            Database::iud("INSERT INTO `mcq`(`lesson_id`,`medium_id`,`question_number`,`question`,`option_a`,`option_b`,`option_c`,`option_d`,`correct_option`,`created_at`)
            VALUES('" . $lesson_id . "','" . $medium . "','" . $next_question_number . "','" . $question . "','" . $option_A . "','" . $option_B . "','" . $option_C . "','" . $option_D . "','" . $answer . "','" . $date . "')");

            $response["status"] = true;
            $response["message"] = "Quiz Added Success!";
        }
    } catch (Exception $e) {
        $response["message"] = "Error: " . $e->getMessage();
    }
}


header("Content-Type: application/json");
echo json_encode($response);
