<?php
include "connection.php";
header("Content-Type: application/json");

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 6; // 8 cards per page
$offset = ($page - 1) * $limit;

$response = ["status" => false, "data" => [], "total_pages" => 0];

try {
    // Get total categories to calculate total pages
    $totalResult = Database::search("SELECT COUNT(*) as total FROM `category` WHERE `category_status_id` = '1'");
    $totalData = $totalResult->fetch_assoc();
    $total = (int)$totalData['total'];
    $totalPages = ceil($total / $limit);

    // Get categories for current page
    $rs = Database::search("SELECT * FROM `category` WHERE `category_status_id` = '1' ORDER BY id ASC LIMIT $limit OFFSET $offset");
    $categories = [];
    while ($row = $rs->fetch_assoc()) {
        $categories[] = $row;
    }

    $response["status"] = true;
    $response["data"] = $categories;
    $response["total_pages"] = $totalPages;

} catch (Exception $e) {
    $response["message"] = $e->getMessage();
}

echo json_encode($response);
exit;
?>
