<?php
ob_start();
include "connection.php";
ob_clean();

header("Content-Type: application/json");

$response = [
    "status" => false,
    "count" => 0,
    "message" => ""
];

try {
    $json = file_get_contents("php://input");
    $data = json_decode($json, true);
    
    $lesson_id = isset($data["lesson_id"]) ? intval($data["lesson_id"]) : 0;
    
    if ($lesson_id <= 0) {
        $response["message"] = "Invalid lesson ID.";
        echo json_encode($response);
        exit;
    }
    
    // Count all quizzes for this lesson (across all mediums)
    $rs = Database::search("SELECT COUNT(*) AS total FROM `mcq` WHERE `lesson_id` = '" . $lesson_id . "'");
    
    if ($rs && $rs->num_rows > 0) {
        $row = $rs->fetch_assoc();
        $response["status"] = true;
        $response["count"] = intval($row["total"]);
    } else {
        $response["status"] = true;
        $response["count"] = 0;
    }
    
} catch (Exception $e) {
    $response["message"] = "Error: " . $e->getMessage();
}

echo json_encode($response);
exit;

