<?php
session_start();
include "connection.php";

header("Content-Type: application/json");

$response = [
    "status" => false,
    "message" => "",
    "data" => []
];

try {
    $json = file_get_contents("php://input");
    $data = json_decode($json, true);

    $bank_id = isset($data["bank_id"]) ? intval($data["bank_id"]) : 0;

    if ($bank_id <= 0) {
        $response["message"] = "Invalid bank ID";
        echo json_encode($response);
        exit;
    }

    // Load bank details for the selected bank
    $rs = Database::search("SELECT bd.*, b.name as bank_name 
                            FROM `bank_details` bd 
                            INNER JOIN `bank` b ON bd.bank_id = b.id 
                            WHERE bd.bank_id = '" . $bank_id . "' 
                            LIMIT 1");

    if ($rs && $rs->num_rows > 0) {
        $row = $rs->fetch_assoc();
        
        $response["status"] = true;
        $response["data"] = [
            "id" => $row["id"],
            "owner_name" => $row["owner_name"] ?? "",
            "acc_number" => $row["acc_number"] ?? "",
            "bank_name" => $row["bank_name"] ?? "",
            "branch" => $row["branch"] ?? ""
        ];
    } else {
        $response["status"] = false;
        $response["message"] = "Bank details not found";
    }

} catch (Exception $e) {
    $response["message"] = "Error: " . $e->getMessage();
}

echo json_encode($response);
exit;

