<?php
session_start();
include "connection.php";

header("Content-Type: application/json");

$response = [
    "status" => false,
    "message" => "",
    "data" => []
];

try {
    // Load all banks
    $rs = Database::search("SELECT * FROM `bank` ORDER BY `id` ASC");

    if ($rs && $rs->num_rows > 0) {
        $banks = [];
        while ($row = $rs->fetch_assoc()) {
            $banks[] = [
                "id" => $row["id"],
                "name" => $row["name"]
            ];
        }

        $response["status"] = true;
        $response["data"] = $banks;
    } else {
        $response["status"] = true;
        $response["message"] = "No banks found";
        $response["data"] = [];
    }

} catch (Exception $e) {
    $response["message"] = "Error: " . $e->getMessage();
}

echo json_encode($response);
exit;

