<?php
// Suppress any output before JSON
ob_start();

include "connection.php";

// Clear any output buffer
ob_clean();

header("Content-Type: application/json");

$response = [
    "status" => false,
    "data" => [
        "students" => 0,
        "courses" => 0,
        "subjects" => 0
    ],
    "message" => ""
];

try {
    // Count registered students
    $students_rs = Database::search("SELECT COUNT(*) AS total FROM `student`");
    if ($students_rs && $students_rs->num_rows > 0) {
        $students_row = $students_rs->fetch_assoc();
        $response["data"]["students"] = intval($students_row["total"]);
    }

    // Count courses
    $courses_rs = Database::search("SELECT COUNT(*) AS total FROM `course`");
    if ($courses_rs && $courses_rs->num_rows > 0) {
        $courses_row = $courses_rs->fetch_assoc();
        $response["data"]["courses"] = intval($courses_row["total"]);
    }

    // Count subjects
    $subjects_rs = Database::search("SELECT COUNT(*) AS total FROM `subject`");
    if ($subjects_rs && $subjects_rs->num_rows > 0) {
        $subjects_row = $subjects_rs->fetch_assoc();
        $response["data"]["subjects"] = intval($subjects_row["total"]);
    }

    $response["status"] = true;
} catch (Exception $e) {
    $response["message"] = "Error: " . $e->getMessage();
}

echo json_encode($response);
exit;

