<?php
ob_start();
session_start();
include "connection.php";
include "validation.php";
ob_clean();

header("Content-Type: application/json");

$response = [
    "status" => false,
    "data" => [],
    "message" => ""
];

try {
    if (!isset($_SESSION["user"]) || !isset($_SESSION["user"]["id"])) {
        $response["message"] = "Unauthorized access.";
        echo json_encode($response);
        exit;
    }

    $student_id = $_SESSION["user"]["id"];
    $student_id = intval($student_id);

    // Load all pending requests (status = 1) for this student
    $rs = Database::search("
        SELECT sr.id AS request_id,
               sr.subject_id,
               sub.title AS subject_title,
               sr.requested_at
        FROM subject_requests sr
        INNER JOIN subject sub ON sr.subject_id = sub.id
        WHERE sr.student_id = '" . $student_id . "' 
        AND sr.request_status_id = '1'
        ORDER BY sr.requested_at DESC
    ");

    $data = [];
    if ($rs) {
        while ($row = $rs->fetch_assoc()) {
            $data[] = $row;
        }
    }

    $response["status"] = true;
    $response["data"] = $data;

} catch (Exception $e) {
    $response["message"] = "Error: " . $e->getMessage();
}

echo json_encode($response);
exit;

