<?php
// Suppress any output before JSON
ob_start();

include "connection.php";
include "validation.php";

// Clear any output buffer
ob_clean();

header("Content-Type: application/json");

$response = [
    "status" => false,
    "message" => ""
];

try {
    $json = file_get_contents("php://input");
    $data = json_decode($json, true);

    if (!$data) {
        $response["message"] = "Invalid request data.";
        echo json_encode($response);
        exit;
    }

    $email = isset($data["email"]) ? trim($data["email"]) : "";
    $newPassword = isset($data["newPassword"]) ? trim($data["newPassword"]) : "";
    $rePassword = isset($data["rePassword"]) ? trim($data["rePassword"]) : "";
    $vcode = isset($data["vcode"]) ? trim($data["vcode"]) : "";

    // Validation
    if (empty($email)) {
        $response["message"] = "Email is required.";
        echo json_encode($response);
        exit;
    }

    if (empty($vcode)) {
        $response["message"] = "Verification code is required.";
        echo json_encode($response);
        exit;
    }

    if (strlen($vcode) !== 5 || !is_numeric($vcode)) {
        $response["message"] = "Invalid verification code format.";
        echo json_encode($response);
        exit;
    }

    if (empty($newPassword)) {
        $response["message"] = "New password is required.";
        echo json_encode($response);
        exit;
    }

    if (empty($rePassword)) {
        $response["message"] = "Please confirm your password.";
        echo json_encode($response);
        exit;
    }

    if ($newPassword !== $rePassword) {
        $response["message"] = "Passwords do not match.";
        echo json_encode($response);
        exit;
    }

    if (!isValidPassword($newPassword)) {
        $response["message"] = "Invalid password format. Password must be at least 8 characters with 1 uppercase, 1 lowercase, 1 number, and 1 special character.";
        echo json_encode($response);
        exit;
    }

    // Sanitize inputs
    Database::setUpConnection();
    if (Database::$connection) {
        $email = mysqli_real_escape_string(Database::$connection, $email);
        $vcode = mysqli_real_escape_string(Database::$connection, $vcode);
        $newPassword = mysqli_real_escape_string(Database::$connection, $newPassword);
    }

    // Check if email exists and verification code matches
    $rs = Database::search("SELECT * FROM `student` WHERE `email` = '" . $email . "' AND `verification_code` = '" . $vcode . "'");
    
    if ($rs === false) {
        $response["message"] = "Database error occurred.";
        echo json_encode($response);
        exit;
    }

    if ($rs->num_rows != 1) {
        $response["message"] = "Invalid email or verification code.";
        echo json_encode($response);
        exit;
    }

    // Update password and clear verification code
    Database::iud("UPDATE `student` SET `password` = '" . $newPassword . "', `verification_code` = '' WHERE `email` = '" . $email . "'");

    $response["status"] = true;
    $response["message"] = "Password reset successfully! You can now login with your new password.";

} catch (Exception $e) {
    $response["message"] = "Error: " . $e->getMessage();
} catch (Error $e) {
    $response["message"] = "Error: " . $e->getMessage();
}

echo json_encode($response);
exit;

