<?php
session_start();
include "connection.php";
include "validation.php";

header("Content-Type: application/json");

$response = [
    "status" => false,
    "message" => ""
];

try {
    // Get JSON from frontend
    $data = json_decode(file_get_contents("php://input"), true);

    // Example JSON: 
    // {
    //   "answers": [
    //     {"question": "...", "options": {...}, "selected": "A", "correct": "C"},
    //     ...
    //   ],
    //   "score": 10,
    //   "total": 15
    // }

    if (!isset($data["answers"]) || !isset($data["score"]) || !isset($data["total"])) {
        throw new Exception("Invalid data received.");
    }

    // Save answers & score in session
    $_SESSION["answers"] = $data["answers"];
    $_SESSION["score"] = $data["score"];
    $_SESSION["total"] = $data["total"];

    $response["status"] = true;
    $response["message"] = "Exam data saved successfully.";
} catch (Exception $e) {
    $response["status"] = false;
    $response["message"] = $e->getMessage();
}

echo json_encode($response);
exit;
?>
