<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student's Words Section</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="common.css">
    <!-- AOS Animation CSS -->
    <link href="https://unpkg.com/aos@2.3.4/dist/aos.css" rel="stylesheet">
    <style>
        /* Section title */
        .section-title {
            color: var(--balck);
            font-weight: 700;
            font-size: 1.8rem;
            text-align: center;
            margin-bottom: 10px;
        }

        .section-title span {
            color: var(--secondary);
        }

        /* Subtitle */
        .section-subtitle {
            text-align: center;


            color: var(--gray);
            font-size: 0.95rem;
        }

        /* Testimonial box */
        .testimonial-box {
            height: 200px;
            border: 1px solid var(--primary);
            border-radius: 7px;
            padding: 50px;
            max-width: 600px;
            margin: 0 auto;
            background: #fff;
            text-align: center;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.05);
        }

        .testimonial-text {
            color: var(--gray);
            font-size: 0.95rem;
            margin-bottom: 15px;
        }

        .testimonial-name {
            color: var(--balck);
            font-weight: 600;
        }

        /* Carousel indicators */
        .carousel-indicators [data-bs-target] {
            background-color: #d1d1d1;
            width: 12px;
            height: 12px;
            border-radius: 40%;
        }

        .carousel-indicators .active {
            background-color: #e63946;
        }

        /* Responsive fix for testimonial box on 320px screens */
        @media (max-width: 320px) {
            .testimonial-box {
                max-width: 280px;
                padding: 25px;
                height: auto;
            }

            .testimonial-text {
                font-size: 0.85rem;
            }

            .testimonial-name {
                font-size: 0.9rem;
            }
        }

        @media (min-width: 320px) {
            .testimonial-box {
                max-width: 460px;
                padding: 40px;
                height: auto;
            }

            .testimonial-text {
                font-size: 0.99rem;
            }

            .testimonial-name {
                font-size: 1.0rem;
            }
        }
    </style>
</head>

<body>

    <section class="py-5 my-5 ">
        <div class="container">

            <div data-aos="fade-up" class="mb-5">
                <h2 class="section-title ">Students’s <span>Words</span></h2>
                <p class="section-subtitle col-md-12 col-lg-10 col-xl-8 mx-auto">
                    Our e-exam platform has helped thousands of students achieve better results through a fast,
                    secure, and user-friendly online exam experience.
                    Here’s what our students say about learning and testing with us.
                </p>

            </div>

            <!-- Carousel -->
            <div id="testimonialCarousel" class="carousel slide" data-bs-ride="carousel" data-aos="zoom-in">
                <div class="carousel-inner">

                    <!-- Slide 1 -->
                    <div class="carousel-item active">
                        <div class="testimonial-box">
                            <p class="testimonial-text">
                                “The e-exam system is very smooth and easy to use. I was able to complete all my subjects
                                without any technical issues. The timer and instant results helped me a lot.”
                            </p>
                            <p class="testimonial-name">Tharindu Perera</p>
                        </div>
                    </div>

                    <!-- Slide 2 -->
                    <div class="carousel-item">
                        <div class="testimonial-box">
                            <p class="testimonial-text">
                                “I really like the clean interface. The mock tests and subject-wise MCQs improved my confidence.
                                The platform works great even on my phone.”
                            </p>
                            <p class="testimonial-name">Kasuni Dilshara</p>
                        </div>
                    </div>

                    <!-- Slide 3 -->
                    <div class="carousel-item">
                        <div class="testimonial-box">
                            <p class="testimonial-text">
                                “Best online exam experience I’ve had. No lag, easy navigation, and clear instructions.
                                Getting my results instantly saved so much time.”
                            </p>
                            <p class="testimonial-name">Sahan Jayasuriya</p>
                        </div>
                    </div>

                    <!-- Slide 4 -->
                    <div class="carousel-item">
                        <div class="testimonial-box">
                            <p class="testimonial-text">
                                “E-Exam helped me study better. The subject filter and past papers section made it easy to prepare.
                                I recommend this platform for any student.”
                            </p>
                            <p class="testimonial-name">Dinithi Senanayake</p>
                        </div>
                    </div>

                    <!-- Slide 5 -->
                    <div class="carousel-item">
                        <div class="testimonial-box">
                            <p class="testimonial-text">
                                “The exam portal works perfectly even with low internet. I finished all my exams on time.
                                The automatic saving feature is a lifesaver!”
                            </p>
                            <p class="testimonial-name">Ravindu Madushan</p>
                        </div>
                    </div>

                </div>

                <!-- Carousel indicators -->
                <div class="carousel-indicators position-static mt-4">
                    <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="0" class="active"></button>
                    <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="1"></button>
                    <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="2"></button>
                    <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="3"></button>
                    <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="4"></button>
                </div>
            </div>
        </div>
    </section>




    </script src="common.js">
    </script>
    <!-- AOS Animation Script -->
    <script src="https://unpkg.com/aos@2.3.4/dist/aos.js"></script>
    <script>
        AOS.init({
            duration: 1000,
            once: true,
            offset: 100,
        });
    </script>
</body>

</html>