<?php
session_start();
include "Backend/Process/connection.php";
$student_id = $_SESSION["user"]["id"];
if (isset($_SESSION["user"])) {
?>

    <!DOCTYPE html>
    <html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Sri Lanka’s First Digital Exam & Exam Practice Platform</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
        <link rel="icon" type="image/png" href="Resources/Logo/icon.png">

        <link rel="stylesheet" href="common.css">
        <style>
            /* Tabs */
            .tabs-box {
                background-color: #fff;
                box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
            }

            .tab-btn {
                height: 40px;
                width: 120px;
                border-radius: 8px;
                background: #f5f5f5;
                border: none;
                font-weight: 500;
                color: var(--black);
                transition: all 0.3s ease;
            }

            .tab-btn.active {
                background: linear-gradient(to right, var(--primary), var(--secondary));
                color: var(--light);
                transform: translateY(-3px);
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            }

            .tab-btn:hover:not(.active) {
                background: #e9e9e9;
            }


            /* Course List */
            .accordion-button::after {
                transition: transform 0.3s ease;
            }

            .accordion-button:not(.collapsed)::after {
                transform: rotate(180deg);
            }

            /* Dots */
            .dot {
                width: 18px;
                height: 18px;
                border-radius: 4px;
                display: inline-block;
                flex-shrink: 0;
            }

            .dot.red {
                background-color: #ff6666;
            }

            .dot.orange {
                background-color: #ffb347;
            }

            .dot.purple {
                background-color: #7a5af5;
            }

            /* Countdown Badge */
            .countdown {
                background-color: #00c39a;
                color: var(--light);
                border-radius: 6px;
                padding: 5px 10px;
                font-weight: 500;
                box-shadow: 0 2px 4px rgba(0, 0, 0, 0.15);
            }

            /* Buttons */
            .submit-btn {
                background: linear-gradient(to right, var(--primary), var(--secondary));
                color: var(--light);
                border: none;
                border-radius: 6px;
                padding: 6px 18px;
                font-weight: 600;
            }

            .submit-btn:hover {
                background: linear-gradient(to right, var(--secondary), var(--primary));
            }

            .na-btn {
                display: inline-block;
                padding: 6px 14px;
                color: #fff;
                border-radius: 6px;
                font-weight: 600;
            }

            .na-btn.red {
                background: linear-gradient(to right, #e60000, #ff4040);
            }

            .na-btn.green {
                background-color: #00c39a;
            }

            /* Card Styling */
            .accordion-item {
                border-radius: 10px !important;
                background-color: #fff;
            }

            .accordion-button {
                font-weight: 600;
                color: #2b2b2b;
                box-shadow: none !important;
            }

            .accordion-button.subject-btn {
                align-items: flex-start !important;
            }

            .accordion-button.subject-btn .d-flex.flex-grow-1 {
                padding-right: 1rem;
            }

            .accordion-button.collapsed {
                color: #2b2b2b;
                background-color: #fff;
            }

            .accordion-button strong {
                white-space: normal !important;
                word-break: break-word;
                color: var(--black);
            }

            .accordion-body {
                background-color: #fff;
                border-radius: 10px;
            }

            .table th {
                font-weight: 600;
            }

            .legend-dot {
                width: 16px;
                height: 16px;
                border-radius: 4px;
                display: inline-block;
            }

            .legend-dot.red {
                background-color: #ff6666;
            }

            .legend-dot.orange {
                background-color: #ffa726;
            }

            .legend-dot.purple {
                background-color: #7a5af5;
            }

            /* Course Cards */
            #tableSection {
                background-color: #ffffffff !important;
                border-radius: 10px;
                box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
                transition: all 0.3s ease;
                padding: 20px;
            }

            .pagination {
                display: flex;
                gap: 8px;
            }

            .page-btn,
            .page-number {
                border: none;
                background: #e9e9e9ff;
                color: #333;
                padding: 8px 14px;
                font-size: 14px;
                border-radius: 6px;
                cursor: pointer;
                transition: background 0.3s ease, color 0.3s ease;
            }

            .page-btn:hover,
            .page-number:hover {
                background: #e4e4e4;
            }

            .page-number.active {
                background: linear-gradient(180deg, var(--primary), var(--secondary));
                color: #fff;
                font-weight: 600;
            }

            .page-btn {
                font-weight: 600;
            }



            @media (max-width: 992px) {
                .tabs-box {
                    flex-direction: column;
                    align-items: flex-start;
                    gap: 15px;
                }

                .navbar-brand {
                    font-size: 18px;
                }
            }

            @media (max-width: 768px) {
                .countdown {
                    margin-top: 8px;
                }

                .subject-btn {
                    flex-direction: column;
                    align-items: flex-start;
                }

                .subject-btn>.d-flex.flex-grow-1 {
                    width: 100%;
                }

                .subject-btn .ms-auto {
                    align-self: center;
                    margin: 0 !important;
                    margin-top: 1.5rem !important;
                }

                .course-btn strong,
                .subject-btn strong,
                .lesson-btn strong {
                    font-size: 14px !important;
                    font-weight: 600 !important;
                    color: var(--black) !important;
                }
            }



            #outdatedContent .course-row {
                background: #fff;
                padding: 12px 16px;
                border-radius: 10px;
                box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1);
                display: flex;
                justify-content: space-between;
                align-items: center;
                gap: 10px;
                margin-bottom: 12px;
            }

            #outdatedContent .course-left {
                display: flex;
                align-items: center;
                gap: 10px;
                flex: 1;
                /* allow text to shrink properly */
                min-width: 0;
            }

            .subject {
                font-size: 15px;

                max-width: 100%;
                line-height: 1.3;
                display: -webkit-box;
                -webkit-line-clamp: 2;
                -webkit-box-orient: vertical;
                overflow: hidden;
                text-overflow: ellipsis;
                white-space: normal;
                text-align: left;
            }

            /* Subject row layout fix */
            .subject-btn {
                display: flex !important;
                justify-content: space-between !important;
                align-items: center !important;
                gap: 10px !important;
                padding-right: 1.5rem !important;
            }

            .subject-btn .d-flex.align-items-center.gap-2.flex-grow-1 {
                display: flex !important;
                align-items: center !important;
                gap: 10px !important;
                flex: 1 !important;
                min-width: 0 !important;
            }

            .subject-btn .subject {
                font-size: 15px !important;
                color: var(--black) !important;
                line-height: 1.4 !important;
                display: -webkit-box !important;
                -webkit-line-clamp: 2 !important;
                -webkit-box-orient: vertical !important;
                overflow: hidden !important;
                text-overflow: ellipsis !important;
                white-space: normal !important;
                text-align: left !important;
            }

            .subject-btn .ms-auto.me-4 {
                flex-shrink: 0 !important;
                margin-left: auto !important;
                display: flex !important;
                align-items: center !important;
            }

            .subject-btn .countdown {
                white-space: nowrap !important;
                font-weight: 500 !important;
                color: var(--light) !important;
                font-size: 14px !important;
            }

            .request-btn {
                white-space: nowrap;
                height: 30px;
                padding: 0 15px;
                transition: 0.3s;
                flex-shrink: 0;
                background: linear-gradient(to right, var(--primary), var(--secondary));
                color: var(--light);
                border: none;
                border-radius: 6px;
                font-weight: 600;
            }

            .request-btn:hover {
                white-space: nowrap;
                height: 30px;
                padding: 0 15px;
                transition: 0.3s;
                flex-shrink: 0;
                background: linear-gradient(to right, var(--secondary), var(--primary));
                color: var(--light);
                border: none;
                border-radius: 6px;
                font-weight: 600;
                transform: translateY(-3px);
            }

            /* Responsive adjustment for Request button and timer on mobile */
            @media (max-width: 768px) {
                .request-btn {
                    height: 26px !important;
                    padding: 0 12px !important;
                    font-size: 13px !important;
                }

                .request-timer {
                    font-size: 13px !important;
                    margin-right: 6px !important;
                }
            }


            .dot.orange {
                background-color: orange;
            }

            .dot.red {
                background-color: red;
            }

            /* === Unified Styling for Course, Subject & Lesson Bars === */
            .course-btn,
            .subject-btn,
            .lesson-btn {
                background-color: #fff !important;
                border: none !important;
                border-radius: 10px !important;
                padding: 14px 20px !important;
                font-weight: 600 !important;
                color: #2b2b2b !important;
                box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08) !important;
                display: flex !important;
                justify-content: space-between !important;
                align-items: center !important;
                width: 100% !important;
                text-align: left !important;
                transition: all 0.3s ease !important;
            }

            .course-btn:hover,
            .subject-btn:hover,
            .lesson-btn:hover {
                background: #f9f9f9 !important;
                transform: translateY(-2px);
            }

            .course-btn strong,
            .subject-btn strong,
            .lesson-btn strong {
                font-size: 15px !important;
                font-weight: 600 !important;
                color: var(--black) !important;
                text-transform: none !important;
            }

            .course-btn.collapsed,
            .subject-btn.collapsed,
            .lesson-btn.collapsed {
                background-color: #fff !important;
                box-shadow: 0 1px 4px rgba(0, 0, 0, 0.05) !important;
            }

            .accordion-item {
                border: none !important;
                background-color: transparent !important;
                box-shadow: none !important;
                margin-bottom: 10px !important;
            }

            /* === Mobile Fix for Subject Row Layout === */
            @media (max-width: 768px) {
                .subject-btn {
                    flex-direction: row !important;
                    /* Keep countdown on right */
                    align-items: flex-start !important;
                }

                .subject-btn .d-flex.align-items-center.gap-2.flex-grow-1 {
                    flex: 1 !important;
                    min-width: 0 !important;
                }

                .subject-btn .subject {
                    -webkit-line-clamp: 3 !important;
                    /* show up to 3 lines on mobile */
                    display: -webkit-box !important;
                    -webkit-box-orient: vertical !important;
                    overflow: hidden !important;
                    text-overflow: ellipsis !important;
                    line-height: 1.4 !important;
                    white-space: normal !important;
                }

                .subject-btn .ms-auto.me-4 {
                    margin-left: auto !important;
                    align-self: flex-start !important;
                }

                .subject-btn .countdown {
                    white-space: nowrap !important;
                    font-size: 13px !important;
                }
            }


            /* No Content */
            .center-full {
                height: 100%;
                display: flex;
                align-items: center;
                justify-content: center;
                flex-direction: column;
                gap: 12px;
                background: #f5f7fa;
                font-family: system-ui, sans-serif;
                color: #333;
            }

            .bubble {
                padding: 28px 36px;
                border-radius: 14px;
                background: #fff;
                box-shadow: 0 10px 30px rgba(16, 24, 40, 0.06);
                text-align: center;
                border: 1px solid #e6e9ef;
            }

            .big {
                font-size: 20px;
                font-weight: 600;
            }

            .muted {
                font-size: 13px;
                color: #757b85;
                margin-top: 6px;
            }

            .table-responsive {
                max-height: 400px;
                overflow-y: auto;
            }

            .table thead th {
                position: sticky;
                top: 0;
                background: #fff;
                z-index: 2;
            }

            /* Subject row mobile optimization */
            @media (max-width: 577px) {
                .subject-btn {
                    flex-direction: row !important;
                    justify-content: space-between !important;
                    align-items: center !important;
                    gap: 10px !important;
                    padding-right: 0.5rem !important;
                }

                .subject-btn .d-flex.align-items-center.gap-2.flex-grow-1 {
                    flex: 1 !important;
                    min-width: 0 !important;
                    gap: 10px !important;
                }

                .subject-btn .subject {
                    font-size: 14px !important;
                    line-height: 1.4 !important;
                    margin-right: 10px !important;
                    overflow-wrap: break-word !important;
                    white-space: normal !important;
                }

                .subject-btn .ms-auto {
                    flex-shrink: 0 !important;
                    margin-left: auto !important;
                }

                .subject-btn .countdown {
                    font-size: 13px !important;
                    white-space: nowrap !important;
                    margin-left: auto !important;
                }
            }

            /* Mobile optimization for lesson table */
            @media (max-width: 577px) {
                .table thead th {
                    font-size: 12px !important;
                    padding: 6px !important;
                }

                .table tbody td {
                    font-size: 12px !important;
                    padding: 6px !important;
                }

                .table tbody td span.na-btn,
                .table tbody td button.submit-btn {
                    font-size: 11px !important;
                    padding: 4px 6px !important;
                }
            }
        </style>
    </head>

    <body>

        <?php include 'Navbar.php'; ?>

        <div style="margin-top: 100px; height: auto; min-height: 100vh;">

            <div class="container my-4">
                <div class="tabs-box d-flex flex-wrap justify-content-between align-items-center p-3 rounded-3">
                    <div class="d-flex gap-4 align-items-center mb-2 mb-md-0">
                        <button class="tab-btn active" data-target="#myCoursesContent">My Courses</button>
                        <button class="tab-btn" data-target="#outdatedContent">Outdated</button>
                    </div>
                    <div class="d-flex align-items-center gap-4">
                        <div class="d-flex align-items-center gap-2">
                            <span class="legend-dot red"></span><small>Course</small>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <span class="legend-dot orange"></span><small>Subject</small>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <span class="legend-dot purple"></span><small>Lesson</small>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container">


                <!-- My Courses Panel -->
                <div id="myCoursesContent" class="tab-content">


                    <!-- No Content  -->
                    <div class="center-full d-none">
                        <div class="bubble" role="status" aria-live="polite">
                            <div class="big">There is no content available.</div>
                            <div class="muted">You can select a course from the home page.</div>
                        </div>
                    </div>
                    <!-- No Content  -->

                    <div class="container my-4 ">
                        <div class="accordion" id="courseAccordion">
                            <div class="course-set mb-4">

                                <?php
                                $course_rs = Database::search("SELECT DISTINCT ss.course_id, c.title AS course_title FROM student_subject ss INNER JOIN course c ON ss.course_id = c.id
                                WHERE ss.student_id = '" . $student_id . "' ");

                                $course_rows = $course_rs->num_rows;

                                if ($course_rows > 0) {
                                    for ($x = 0; $x < $course_rows; $x++) {
                                        $course_data = $course_rs->fetch_assoc();
                                        $cid = $course_data["course_id"];
                                ?>

                                        <!-- COURSE -->
                                        <div class="accordion-item border-0 mb-3 shadow-sm rounded-3">
                                            <h2 class="accordion-header">
                                                <button
                                                    class="accordion-button course-btn collapsed bg-white rounded-3 d-flex flex-wrap justify-content-between align-items-center text-start"
                                                    type="button"
                                                    data-bs-toggle="collapse"
                                                    data-bs-target="#subjects-<?php echo $cid; ?>">
                                                    <div class="d-flex align-items-center gap-2 flex-grow-1 text-truncate">
                                                        <span class="legend-dot red flex-shrink-0"></span>
                                                        <strong class="text-truncate" style="max-width: 100%;">
                                                            <?php echo strtoupper(htmlspecialchars($course_data["course_title"])); ?>
                                                        </strong>
                                                    </div>
                                                </button>
                                            </h2>
                                        </div>

                                        <!-- SUBJECTS -->
                                        <div class="accordion-collapse collapse" id="subjects-<?php echo $cid; ?>">
                                            <div class="accordion-body p-0">

                                                <?php
                                                $subject_rs = Database::search("SELECT * FROM student_subject 
    INNER JOIN `subject` ON `student_subject`.`subject_id` = `subject`.`id`
    WHERE `student_subject`.`course_id` = '" . $cid . "' 
    AND `student_subject`.`student_id` = '" . $student_id . "' AND `student_subject`.`student_subject_status_id` = '1' ");

                                                if ($subject_rs->num_rows > 0) {
                                                    while ($subject_data = $subject_rs->fetch_assoc()) {
                                                        $sid = $subject_data["subject_id"];
                                                        $expire_date = $subject_data["expire_date"];
                                                ?>
                                                        <!-- SUBJECT ITEM -->
                                                        <div class="accordion mb-2 subject-item"
                                                            data-subject-id="<?php echo $sid; ?>"
                                                            data-expire="<?php echo htmlspecialchars($expire_date); ?>">
                                                            <div class="accordion-item border-0 shadow-sm rounded-3 mb-2">
                                                                <h2 class="accordion-header">
                                                                    <button
                                                                        class="accordion-button subject-btn collapsed bg-white rounded-3 d-flex justify-content-between align-items-center"
                                                                        type="button"
                                                                        data-bs-toggle="collapse"
                                                                        data-bs-target="#lessons-<?php echo $cid . '-' . $sid; ?>">
                                                                        <div class="d-flex align-items-center gap-2 flex-grow-1">
                                                                            <span class="dot orange"></span>
                                                                            <strong class="subject"><?php echo htmlspecialchars($subject_data["title"]); ?></strong>
                                                                        </div>
                                                                        <div class="ms-auto">
                                                                            <span class="countdown text-danger fw-bold"
                                                                                data-expire="<?php echo htmlspecialchars($expire_date); ?>">
                                                                                Calculating...
                                                                            </span>
                                                                        </div>
                                                                    </button>
                                                                </h2>
                                                            </div>
                                                        </div>

                                                        <!-- LESSONS -->
                                                        <div class="accordion-collapse collapse" id="lessons-<?php echo $cid . '-' . $sid; ?>">
                                                            <div class="accordion-body p-0 lessons-container">
                                                                <?php
                                                                $lesson_rs = Database::search("SELECT * FROM `lesson` WHERE `subject_id` = '" . $sid . "' ORDER BY id ASC");
                                                                if ($lesson_rs->num_rows > 0) {
                                                                    while ($lesson = $lesson_rs->fetch_assoc()) {
                                                                        $lid = $lesson["id"];
                                                                ?>
                                                                        <div class="accordion mb-3 lesson-item">
                                                                            <div class="accordion-item border-0 shadow-sm rounded-3 mb-2">
                                                                                <h2 class="accordion-header">
                                                                                    <button
                                                                                        class="accordion-button lesson-btn collapsed bg-white rounded-3 d-flex justify-content-between align-items-center"
                                                                                        type="button"
                                                                                        data-bs-toggle="collapse"
                                                                                        data-bs-target="#table-<?php echo $cid . '-' . $sid . '-' . $lid; ?>">
                                                                                        <div class="d-flex align-items-center gap-2 flex-grow-1 text-truncate">
                                                                                            <span class="dot purple flex-shrink-0"></span>
                                                                                            <strong class="text-truncate" style="max-width: 100%; font-size: 15px;">
                                                                                                <?php echo htmlspecialchars($lesson["title"]); ?>
                                                                                            </strong>
                                                                                        </div>
                                                                                    </button>
                                                                                </h2>
                                                                            </div>
                                                                        </div>

                                                                        <!-- LESSON TABLE -->
                                                                        <div class="accordion-collapse collapse" id="table-<?php echo $cid . '-' . $sid . '-' . $lid; ?>">
                                                                            <div class="accordion-body rounded-3" id="tableSection">
                                                                                <div class="table-responsive" style="max-height:400px; overflow-y:auto;">
                                                                                    <table class="table table-bordered text-center align-middle">
                                                                                        <thead class="table-light">
                                                                                            <tr>
                                                                                                <th>Submit / Re-Apply</th>
                                                                                                <th>Submitted Date</th>
                                                                                                <th>Marks</th>
                                                                                                <th>Status</th>
                                                                                            </tr>
                                                                                        </thead>
                                                                                        <tbody>
                                                                                            <?php
                                                                                            $student_id = $_SESSION["user"]["id"];
                                                                                            $result_rs = Database::search("
    SELECT * FROM `student_subject_results`
    WHERE `student_id` = '$student_id'
      AND `subject_id` = '$sid'
      AND `lesson_id` = '$lid'
    ORDER BY `submitted_date` DESC
    LIMIT 1
");

                                                                                            if ($result_rs->num_rows > 0) {
                                                                                                $result_data = $result_rs->fetch_assoc();

                                                                                                // marks stores number of correct answers (integer)
                                                                                                $marks = isset($result_data["marks"]) ? (int)$result_data["marks"] : 0;

                                                                                                // try to get total questions (if stored)
                                                                                                $total_questions = isset($result_data["total_questions"]) ? (int)$result_data["total_questions"] : 0;

                                                                                                // fallback: count MCQs for this lesson if total_questions not stored
                                                                                                if ($total_questions === 0) {
                                                                                                    $cnt_rs = Database::search("SELECT COUNT(*) AS cnt FROM `mcq` WHERE `lesson_id` = '" . $lid . "'");
                                                                                                    if ($cnt_rs->num_rows > 0) {
                                                                                                        $cnt_row = $cnt_rs->fetch_assoc();
                                                                                                        $total_questions = (int)$cnt_row["cnt"];
                                                                                                    }
                                                                                                }

                                                                                                $date = date("Y-m-d h:i A", strtotime($result_data["submitted_date"]));
                                                                                                $status = $result_data["status"];

                                                                                                // prepare display string and pass/fail
                                                                                                if ($total_questions > 0) {
                                                                                                    $display = $marks . "/" . $total_questions;        // e.g. 20/50
                                                                                                    $ratio = $marks / $total_questions;
                                                                                                    $isPass = ($ratio >= 0.5); // pass threshold 50%
                                                                                                } else {
                                                                                                    // if total unknown, just show the raw marks (fallback)
                                                                                                    $display = (string)$marks;
                                                                                                    $isPass = ($marks >= 50); // fallback interpretation (old behaviour)
                                                                                                }
                                                                                            ?>
                                                                                                <tr>
                                                                                                    <td style="padding-right: 15px;">
                                                                                                        <button class="submit-btn btn btn-primary" data-subject-id="<?php echo $sid; ?>" data-lesson-id="<?php echo $lid; ?>" style="border: none; box-shadow: none;">
                                                                                                            RE-APPLY
                                                                                                        </button>
                                                                                                    </td>
                                                                                                    <td style="padding-left: 15px;"><span class="na-btn bg-dark"><?php echo $date; ?></span></td>
                                                                                                    <td>
                                                                                                        <?php if ($isPass) { ?>
                                                                                                            <span class="na-btn green"><?php echo htmlspecialchars($display); ?></span>
                                                                                                        <?php } else { ?>
                                                                                                            <span class="na-btn red"><?php echo htmlspecialchars($display); ?></span>
                                                                                                        <?php } ?>
                                                                                                    </td>
                                                                                                    <td>
                                                                                                        <?php if ($status == "Completed") { ?>
                                                                                                            <span class="na-btn green">Completed</span>
                                                                                                        <?php } else { ?>
                                                                                                            <span class="na-btn red"><?php echo htmlspecialchars($status); ?></span>
                                                                                                        <?php } ?>
                                                                                                    </td>
                                                                                                </tr>
                                                                                            <?php
                                                                                            } else {
                                                                                                // no result found — keep your existing fallback row (unchanged)
                                                                                            ?>
                                                                                                <tr>
                                                                                                    <td style="padding-right: 15px;">
                                                                                                        <button class="submit-btn btn" data-subject-id="<?php echo $sid; ?>" data-lesson-id="<?php echo $lid; ?>" style="border: none; box-shadow: none;">
                                                                                                            SUBMIT
                                                                                                        </button>
                                                                                                    </td>
                                                                                                    <td style="padding-left: 15px;"><span class="na-btn bg-dark">N/A</span></td>
                                                                                                    <td><span class="na-btn red">N/A</span></td>
                                                                                                    <td><span class="na-btn green">N/A</span></td>
                                                                                                </tr>
                                                                                            <?php
                                                                                            }
                                                                                            ?>
                                                                                        </tbody>
                                                                                    </table>
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                <?php
                                                                    }
                                                                } else {
                                                                    echo "<p class='p-3 text-muted'>No lessons available for this subject.</p>";
                                                                }
                                                                ?>
                                                            </div>

                                                            <!-- Hidden “Request Again” button (will show after expiry) -->
                                                            <div class="text-center my-3">
                                                                <button class="btn btn-outline-primary request-btn d-none"
                                                                    data-subject-id="<?php echo $sid; ?>">
                                                                    Request Again
                                                                </button>
                                                            </div>
                                                        </div>
                                                <?php
                                                    }
                                                } else {
                                                    echo "<p class='p-3 text-muted'>No subjects found for this course.</p>";
                                                }
                                                ?>

                                            </div>
                                        </div>
                                <?php
                                    }
                                } else {
                                    echo "<p class='p-3 text-muted'>No enrolled courses found.</p>";
                                }
                                ?>

                            </div>
                        </div>


                    </div>



                </div>



            </div>


            <!-- Outdated Panel -->

            <div id="outdatedContent" class="tab-content " style="display: none;">

                <!-- No Content  -->
                <div class="center-full d-none">
                    <div class="bubble" role="status" aria-live="polite">
                        <div class="big">There is no content available.</div>
                        <div class="muted">You can select a course from the home page.</div>
                    </div>
                </div>
                <!-- No Content  -->

                <div class="">

                    <div class="container my-4 ">


                    </div>



                </div>
            </div>



        </div>
        </div>


        <!-- Language Selection Modal -->
        <!-- Language Selection Modal -->
        <div class="modal fade" id="languageModal" tabindex="-1" aria-labelledby="languageModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 10px;height: 200px;">
                    <div class="modal-header border-0">
                        <h5 class="modal-title w-100 text-center fw-bold text-danger" id="languageModalLabel">Select Language</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        <div class="d-flex justify-content-center gap-4">
                            <button class="btn btn-outline-dark px-5 py-3 fs-5 fw-semibold lang-btn" data-lang="1">සිංහල</button>
                            <button class="btn btn-outline-dark px-5 py-3 fs-5 fw-semibold lang-btn" data-lang="2">English</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <?php include 'Footer.php'; ?>

        <script>
            document.addEventListener('DOMContentLoaded', () => {
                // Reuse in tab switching logic
                const tabButtons = document.querySelectorAll('.tab-btn');
                const tabContents = document.querySelectorAll('.tab-content');

                tabButtons.forEach(button => {
                    button.addEventListener('click', () => {
                        // Tab switching
                        tabButtons.forEach(btn => btn.classList.remove('active'));
                        button.classList.add('active');
                        tabContents.forEach(content => {
                            content.style.display = 'none'; // Reset animation styles when hiding
                            content.querySelectorAll('.fade-up').forEach(el => {
                                el.style.animation = 'none';
                                el.style.opacity = '0';
                                el.style.transform = 'translateY(10px)';
                            });
                        });

                        const targetId = button.getAttribute('data-target');
                        const targetContent = document.querySelector(targetId);
                        if (targetContent) {
                            targetContent.style.display = 'block';

                            // Small timeout to ensure browser applies reset before retriggering animation
                        }
                    });
                });


                // --- Your existing accordion logic START ---
                const allAccordionButtons = document.querySelectorAll('.course-btn, .subject-btn, .lesson-btn');

                function toggleCollapse(button) {
                    const targetSelector = button.getAttribute('data-target');
                    const targetElement = document.querySelector(targetSelector);
                    if (!targetElement) return;

                    const isCollapsing = targetElement.classList.contains('show');

                    if (isCollapsing) {
                        targetElement.classList.remove('show');
                        button.classList.add('collapsed');
                        button.setAttribute('aria-expanded', 'false');

                        if (button.classList.contains('course-btn') || button.classList.contains('subject-btn')) {
                            const nestedCollapses = targetElement.querySelectorAll('.accordion-collapse.show');
                            nestedCollapses.forEach(el => el.classList.remove('show'));
                            const nestedButtons = targetElement.querySelectorAll('.accordion-button:not(.collapsed)');
                            nestedButtons.forEach(btn => btn.classList.add('collapsed'));
                        }
                    } else {
                        targetElement.classList.add('show');
                        button.classList.remove('collapsed');
                        button.setAttribute('aria-expanded', 'true');
                    }
                }

                allAccordionButtons.forEach(button => {
                    button.addEventListener('click', function(e) {
                        e.preventDefault();
                        toggleCollapse(this);
                    });
                });
                // --- Your existing accordion logic END ---

                // --- Open Language Modal on Submit Click ---

            });
        </script>


        <script src="common.js"></script>
        <script src="Backend/Js/StudentSubjects.js"></script>
        <script src="Backend/Js/Exam.js"></script>

        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    </body>

    </html>
<?php
} else {
?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        alert("Unautharized Access");
        window.location = "login.php";
    </script>
<?php
}

?>