<?php
session_start();
include "Backend/Process/connection.php";

$category = $_GET["id"];

// Load category data from database
$category_data = null;
if (!empty($category)) {
    $category_id = intval($category);
    $category_rs = Database::search("SELECT * FROM `category` WHERE `id` = '" . $category_id . "'");
    if ($category_rs && $category_rs->num_rows > 0) {
        $category_data = $category_rs->fetch_assoc();
    }
}

// Set default values if category not found
$category_name = $category_data ? $category_data["title"] : "Category";
$category_description = $category_data ? $category_data["description"] : "No description available.";

?>
<!DOCTYPE html>
<html lang="si">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sri Lanka’s First Digital Exam & Exam Practice Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="Resources/Logo/icon.png">


    <link rel="stylesheet" href="common.css">
    <style>
        .back-btn {
            position: absolute;
            top: 20px;
            left: 20px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 35px;
            height: 35px;
            border-radius: 20%;
            background-color: #ffffff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        @media (max-width: 577px) {
            .course-text {
                text-align: center !important;
                display: flex !important;
                flex-direction: column !important;
                align-items: center !important;
                justify-content: center !important;
            }

            .course-text h1 {
                font-size: 2rem !important;
            }

            .course-text p {
                text-align: center !important;
            }
        }

        .back-btn:hover {
            background-color: #dededeff;
        }

        .back-btn-Area {
            height: 70px;
            background-color: #f8f9fa;
        }

        .back-btn img {
            width: 18px;
            height: 18px;
            object-fit: contain;
            filter: grayscale(60%);
        }

        body {
            margin: 0;
            padding: 0;
            background-color: #f8f9fa;
        }

        .course-banner {
            position: relative;
            display: flex;
            flex-direction: row;
            align-items: stretch;
            overflow: hidden;
            min-height: 300px;
            background-color: #1f1f1f;
            margin-top: 80px;
        }

        .breadcrumb-top {
            position: absolute;
            top: 20px;
            left: 45px;
            z-index: 3;
            color: #bfbfbf;
            font-size: 18px;
            text-transform: uppercase;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .breadcrumb-top img {
            height: 16px;
            margin-top: -2px;
        }

        .course-text {
            position: relative;
            z-index: 2;
            color: #fff;
            padding: 5rem 3rem 3rem 3rem;
            flex: 1;
        }

        .hexagon {
            width: 400px;
            height: 400px;
            clip-path: polygon(25% 0%, 75% 0%, 100% 0%, 100% 100%, 25% 100%, 0% 50%);
            background: url('Resources/Images/Details-Bar.png') center/cover;
        }

        @media (max-width: 768px) {
            .course-banner {
                flex-direction: column;
            }

            .breadcrumb-top {
                position: absolute;
                top: 15px;
                left: 25px;
                margin: 0;
                justify-content: flex-start;
                align-items: center;
                gap: 6px;
                text-align: left;
            }


            .course-text {
                text-align: start;
                padding: 2rem 1.5rem;
                margin-top: 40px;
            }

            .course-text h3,
            .course-text p {
                text-align: start;
            }

            .hexagon {
                display: none;
            }
        }

        .banner-text {
            color: var(--black);
        }

        .tabs-box {
            background-color: #fff;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
        }

        .tab-btn {
            height: 40px;
            width: 120px;
            border-radius: 8px;
            background: #f5f5f5;
            border: none;
            font-weight: 500;
            color: var(--black);
            transition: all 0.3s ease;
        }

        .tab-btn.active {
            background: linear-gradient(to right, var(--primary), var(--secondary));
            color: var(--light);
            transform: translateY(-3px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .tab-btn:hover:not(.active) {
            background: #e9e9e9;
        }

        .accordion-button::after {
            transition: transform 0.3s ease;
        }

        .accordion-button:not(.collapsed)::after {
            transform: rotate(180deg);
        }

        .dot {
            width: 18px;
            height: 18px;
            border-radius: 4px;
            display: inline-block;
            flex-shrink: 0;
        }

        .dot.red {
            background-color: #ff6666;
        }

        .dot.orange {
            background-color: #ffb347;
        }

        .dot.purple {
            background-color: #7a5af5;
        }



        .accordion-item {
            border-radius: 10px !important;
            background-color: #fff;
            transition: background-color 0.3s ease;
        }

        .accordion-button {
            font-weight: 600;
            color: #2b2b2b;
            box-shadow: none !important;
            transition: background-color 0.3s ease;
        }

        .accordion-button.subject-btn {
            align-items: flex-start !important;
        }

        .accordion-button.subject-btn .d-flex.flex-grow-1 {
            padding-right: 1rem;
        }

        .accordion-button.collapsed {
            color: #2b2b2b;
            background-color: #fff;
        }

        .accordion-button strong {
            white-space: normal !important;
            word-break: break-word;
            color: var(--black);
        }

        .accordion-body {
            background-color: #fff;
            border-radius: 10px;
        }

        .legend-dot {
            width: 16px;
            height: 16px;
            border-radius: 4px;
            display: inline-block;
        }

        .legend-dot.red {
            background-color: #ff6666;
        }

        .legend-dot.orange {
            background-color: #ffa726;
        }

        .legend-dot.purple {
            background-color: #7a5af5;
        }

        /* VISUAL FEEDBACK FOR SELECTED SUBJECT */
        .accordion-item.subject-selected>.accordion-header>.subject-btn {
            background-color: #fff8f8 !important;
            border-left: 4px solid #e60000;
        }

        /* CUSTOM CHECKBOX STYLES */
        .custom-checkbox-wrapper {
            position: relative;
            cursor: pointer;
            width: 22px;
            height: 22px;
        }

        .custom-checkbox-wrapper input[type="checkbox"] {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .custom-checkbox-wrapper .checkmark {
            position: absolute;
            top: 0;
            left: 0;
            height: 22px;
            width: 22px;
            background-color: #eee;
            border: 1px solid #ccc;
            border-radius: 5px;
            transition: background-color 0.2s;
        }

        .custom-checkbox-wrapper:hover .checkmark {
            background-color: #ddd;
        }

        .custom-checkbox-wrapper .checkmark:after {
            content: "";
            position: absolute;
            display: none;
            left: 7px;
            top: 2px;
            width: 6px;
            height: 12px;
            border: solid red;
            border-width: 0 3px 3px 0;
            transform: rotate(45deg);
        }

        .custom-checkbox-wrapper input:checked~.checkmark:after {
            display: block;
        }


        .pagination {
            display: flex;
            gap: 8px;
        }

        .page-btn,
        .page-number {
            border: none;
            background: #e9e9e9ff;
            color: #333;
            padding: 8px 14px;
            font-size: 14px;
            border-radius: 6px;
            cursor: pointer;
            transition: background 0.3s ease, color 0.3s ease;
        }

        .page-btn:hover,
        .page-number:hover {
            background: #e4e4e4;
        }

        .page-number.active {
            background: linear-gradient(180deg, var(--primary), var(--secondary));
            color: #fff;
            font-weight: 600;
        }

        .page-btn {
            font-weight: 600;
        }

        @media (max-width: 992px) {
            .tabs-box {
                flex-direction: column;
                align-items: flex-start;
                gap: 15px;
            }

            .navbar-brand {
                font-size: 18px;
            }
        }

        @media (max-width: 768px) {
            .countdown {
                margin-top: 8px;
            }

            .subject-btn {
                flex-direction: column;
                align-items: flex-start;
            }

            .subject-btn>.d-flex.flex-grow-1 {
                width: 100%;
            }

            .subject-btn .ms-auto {
                align-self: center;
                margin: 0 !important;
                margin-top: 1.5rem !important;
            }

            .course-btn strong,
            .subject-btn strong {
                font-size: 14px !important;
            }
        }

        #outdatedContent .course-row {
            background: #fff;
            padding: 12px 16px;
            border-radius: 10px;
            box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 10px;
            margin-bottom: 12px;
        }

        #outdatedContent .course-left {
            display: flex;
            align-items: center;
            gap: 10px;
            flex: 1;
            min-width: 0;
        }

        .subject {
            font-size: 15px;

            max-width: 100%;
            line-height: 1.3;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: normal;
            text-align: left;
        }

        .subject-btn {
            display: flex !important;
            justify-content: space-between !important;
            align-items: center !important;
            gap: 10px !important;
            padding-right: 1.5rem !important;
        }

        .subject-btn .d-flex.align-items-center.gap-2.flex-grow-1 {
            display: flex !important;
            align-items: center !important;
            gap: 10px !important;
            flex: 1 !important;
            min-width: 0 !important;
        }

        .subject-btn .subject {
            font-size: 15px !important;
            color: #222 !important;
            line-height: 1.4 !important;
            display: -webkit-box !important;
            -webkit-line-clamp: 2 !important;
            -webkit-box-orient: vertical !important;
            overflow: hidden !important;
            text-overflow: ellipsis !important;
            white-space: normal !important;
            text-align: left !important;
        }

        .subject-btn .ms-auto.me-4 {
            flex-shrink: 0 !important;
            margin-left: auto !important;
            display: flex !important;
            align-items: center !important;
        }

        .subject-btn .countdown {
            white-space: nowrap !important;
            font-weight: 500 !important;
            color: var(--light) !important;
            font-size: 14px !important;
        }

        .request-btn {
            white-space: nowrap;
            height: 30px;
            padding: 0 15px;
            transition: 0.3s;
            flex-shrink: 0;
            background: linear-gradient(to right, var(--primary), var(--secondary));
            color: var(--light);
            border: none;
            border-radius: 6px;
            font-weight: 600;
        }

        .request-btn:hover {
            white-space: nowrap;
            height: 30px;
            padding: 0 15px;
            transition: 0.3s;
            flex-shrink: 0;
            background: linear-gradient(to right, var(--secondary), var(--primary));
            color: var(--light);
            border: none;
            border-radius: 6px;
            font-weight: 600;
            transform: translateY(-3px);
        }

        .dot.orange {
            background-color: orange;
        }

        .dot.red {
            background-color: red;
        }

        @media (max-width: 768px) {
            .subject-btn {
                flex-direction: row !important;
                align-items: flex-start !important;
            }

            .subject-btn .d-flex.align-items-center.gap-2.flex-grow-1 {
                flex: 1 !important;
                min-width: 0 !important;
            }

            .subject-btn .subject {
                -webkit-line-clamp: 3 !important;
                display: -webkit-box !important;
                -webkit-box-orient: vertical !important;
                overflow: hidden !important;
                text-overflow: ellipsis !important;
                line-height: 1.4 !important;
                white-space: normal !important;
            }

            .subject-btn .ms-auto.me-4 {
                margin-left: auto !important;
                align-self: flex-start !important;
            }

            .subject-btn .countdown {
                white-space: nowrap !important;
                font-size: 13px !important;
            }
        }


        /* Ready to Pay */
        .payment-section {

            margin-top: 50px;
        }

        .payment-container {
            display: flex;
            flex-wrap: wrap;
            gap: 40px;
            justify-content: space-between;
        }

        .ready-to-pay-box {
            flex: 1;
            min-width: 300px;

            border-radius: 12px;


        }

        .ready-to-pay-box h4 {
            font-weight: 700;
            margin-bottom: 20px;
        }

        .ready-course-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            background: #fff;
            border-radius: 10px;
            padding: 15px 20px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
            margin-bottom: 12px;
            transition: 0.3s;
        }

        .ready-course-item:hover {
            transform: translateY(-2px);
        }

        .ready-course-left {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .ready-dot {
            width: 18px;
            height: 18px;
            background-color: #ffb347;
            border-radius: 4px;
        }

        .ready-course-item span {
            font-weight: 600;
            color: #2b2b2b;
        }

        /* Bank Details Box */
        .bank-details-box {
            flex: 1;
            min-width: 300px;
            background: #fff;
            border-radius: 12px;
            padding: 30px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
        }

        .bank-details-box h4 {
            font-weight: 700;
            margin-bottom: 25px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .bank-detail {
            background: #f7f7f7;
            border-radius: 8px;
            padding: 12px 15px;
            margin-bottom: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 15px;
        }

        .bank-detail strong {
            font-weight: 600;
            color: var(--gray);
        }

        .bank-detail .copy-btn {
            background: #9f9f9fff;
            border: none;
            border-radius: 6px;
            padding: 6px 6px;
            transition: background 0.2s ease;
        }

        .bank-detail .copy-btn:hover {
            background: #787878ff;
        }

        .bank-submit-btn {
            background: linear-gradient(to right, var(--primary), var(--secondary));
            color: white;
            border: none;
            border-radius: 10px;
            padding: 15px;
            width: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            font-weight: 600;
            font-size: 16px;
            transition: 0.3s;
        }

        .bank-submit-btn:hover {
            background: linear-gradient(to right, var(--secondary), var(--primary));
            transform: translateY(-3px);

        }

        .bank-footer-text {
            margin-top: 15px;
            color: #444;
            font-size: 14px;
            line-height: 1.4;
        }

        @media (max-width: 992px) {
            .payment-container {
                flex-direction: column;
            }
        }


        /* Summary Section */

        .main-wrapper {
            background-color: #f8f9fa;
            padding: 10px;
            border-radius: 12px;
            margin-top: 20px;
            margin-bottom: 40px;
        }


        .info-card {
            background-color: #ffffff;
            border: none;
            border-radius: 8px;
            padding: 1.5rem;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.05);
        }

        .text-card {
            background-color: #ffffff;
            border: none;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.05);
            height: 100%;
        }

        .text-card .card-body {
            color: #6c757d;
            font-size: 0.95rem;
        }

        .subjects-selected {
            font-weight: 600;
            font-size: 1.2rem;
        }

        .total-amount-header {
            font-weight: 700;
            font-size: 1.4rem;
            color: #212529;
            margin-bottom: 0.25rem;
        }

        .total-amount-value {
            font-weight: 600;
            font-size: 1.2rem;
            color: #343a40;
        }


        .btn-custom {
            padding: 0.6rem 2rem;
            font-weight: 600;
            border: none;
            border-radius: 5px;
            transition: background-color 0.2s ease-in-out;
        }

        .btn-cancel {
            background-color: var(--black) !important;
            color: white !important;
            transition: all 0.3s ease !important;
        }

        .btn-cancel:hover {
            background-color: var(--black);
            transform: translateY(-3px);
            color: white;
        }

        .btn-request {
            background: linear-gradient(to right, var(--primary), var(--secondary)) !important;
            color: white !important;
            transition: all 0.3s ease !important;
        }

        .btn-request:hover {
            background: linear-gradient(to right, var(--secondary), var(--primary));
            transform: translateY(-3px);
            color: white;

        }

        /* Ensure equal sizing and spacing for Cancel and Request buttons */
        .button-group .btn {
            min-width: 150px;
        }

        .button-group {
            gap: 15px;
        }

        /* Equal sizing for Cancel and Request buttons */
        .button-group .btn {
            flex: 1;
            min-width: 150px;
        }

        /* Timer popup styling */
        .timer-popup {
            position: absolute;
            right: 0;
            transform: translateX(110%);
            background: linear-gradient(135deg, #00c39a, #00a382);
            color: #fff;
            padding: 6px 12px;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            box-shadow: 0 3px 8px rgba(0, 0, 0, 0.15);
            white-space: nowrap;
            animation: fadeIn 0.3s ease;
            top: 50%;
            transform: translate(110%, -50%);
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translate(120%, -50%);
            }

            to {
                opacity: 1;
                transform: translate(110%, -50%);
            }
        }

        #requestTimer {
            text-align: center;
        }


        @media (max-width: 767px) {
            .info-card {
                text-align: center;
            }

            .info-card .text-end {
                text-align: center !important;
                margin-top: 1rem;
            }

            .button-group {
                justify-content: center;
                width: 100%;
                margin-top: 1rem;
            }

            .main-wrapper {
                padding: 1rem;
            }
        }


        /*Custom Dropdown */
        .custom-dropdown {
            position: relative;
            width: 200px;
            color: var(--black);
        }


        /* Button */
        .dropdown-btn {
            width: 100%;
            border: 2px solid var(--primary);
            border-radius: 50px;
            padding: 10px 16px;
            background-color: transparent;
            font-size: 14px;
            color: var(--black);
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .dropdown-btn:after {
            content: "\25BC";
            /* ▼ icon */
            font-size: 12px;
            margin-left: 8px;
        }

        /* Dropdown list */
        .dropdown-list {
            position: absolute;
            top: 110%;
            left: 0;
            right: 0;
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
            display: none;
            z-index: 1000;
        }

        .dropdown-list div {
            padding: 10px 16px;
            cursor: pointer;
        }

        .dropdown-list div:hover {
            background-color: #f8f9fa;
        }

        /* Active state */
        .custom-dropdown.active .dropdown-list {
            display: block;
        }

        @media (max-width: 576px) {

            /* Summary top row: subject count + total amount */
            .info-card .d-flex.justify-content-between.align-items-center {
                flex-direction: column !important;
                text-align: center !important;
                gap: 10px !important;
            }

            .info-card .text-end {
                text-align: center !important;
                width: 100% !important;
                margin-top: 10px !important;
            }

            /* Pending Requests Card */
            .text-card {
                margin-bottom: 20px !important;
            }

            /* Button section */
            .button-box .button-group {
                flex-direction: column !important;
                gap: 12px !important;
            }

            .button-box .btn {
                width: 100% !important;
                margin: 0 !important;
            }
        }
    </style>
</head>

<body>

    <?php include "Navbar.php"; ?>

    <div class="course-banner d-flex flex-column flex-md-row align-items-center justify-content-between ">
        <div class="breadcrumb-top">
            <span><?php echo htmlspecialchars($category_name); ?></span>
            <img src="Resources/Icons/right-arrow.png" alt=">">
        </div>
        <div class="course-text text-white">
            <h1 class="fw-bold text-uppercase"><?php echo htmlspecialchars($category_name); ?></h1>
            <p class="mt-3 mb-0">
                <?php echo htmlspecialchars($category_description); ?>
            </p>
        </div>
        <div class="hexagon"></div>
    </div>


    <div style="margin-top: 100px; height: auto; min-height: auto;">

        <div class="container my-4">
            <div class="tabs-box d-flex flex-wrap justify-content-between align-items-center p-3 rounded-3">
                <div class="d-flex gap-4 align-items-center mb-2 mb-md-0">
                    <h5 class="fw-bold banner-text">Select Course & Subject</h5>
                </div>
                <div class="d-flex align-items-center gap-4">
                    <div class="d-flex align-items-center gap-2">
                        <span class="legend-dot red"></span><small>Course</small>
                    </div>
                    <div class="d-flex align-items-center gap-2">
                        <span class="legend-dot orange"></span><small>Subject</small>
                    </div>
                    <div class="d-flex align-items-center gap-2">
                        <span class="legend-dot purple"></span><small>Lesson</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="container">

            <div id="myCoursesContent" class="tab-content">
                <div class="container my-4">
                    <div class="accordion" id="courseAccordion">
                        <div class="course-set mb-4">

                            <div style="background-color: #f7f9fa;" class="course-set mb-4">
                                <?php
                                $crs = Database::search("SELECT * FROM `course` WHERE `category_id` = '" . $category . "' ");
                                if ($crs->num_rows > 0) {
                                    while ($cat_data = $crs->fetch_assoc()) {
                                        $cid = $cat_data["id"];
                                ?>
                                        <div class="course-set mb-3">
                                            <!-- COURSE -->
                                            <div class="accordion-item border-0 mb-3 shadow-sm rounded-3">
                                                <h2 class="accordion-header">
                                                    <button class="accordion-button course-btn collapsed bg-white rounded-3 d-flex flex-wrap justify-content-between align-items-center text-start"
                                                        type="button"
                                                        data-target="#subjects-<?php echo $cid; ?>">
                                                        <div class="d-flex align-items-center gap-2 flex-grow-1 text-truncate">
                                                            <span class="legend-dot red flex-shrink-0"></span>
                                                            <strong class="text-truncate"><?php echo strtoupper(htmlspecialchars($cat_data["title"])); ?></strong>
                                                        </div>
                                                    </button>
                                                </h2>
                                            </div>

                                            <!-- SUBJECTS -->
                                            <div style="background-color: #f7f9fa;" class="accordion-collapse collapse" id="subjects-<?php echo $cid; ?>">
                                                <div class="accordion-body p-0 mt-2">
                                                    <?php
                                                    $srs = Database::search("SELECT * FROM `subject` WHERE `course_id` = '" . $cid . "'");
                                                    if ($srs->num_rows > 0) {
                                                        while ($sub_data = $srs->fetch_assoc()) {
                                                            $sid = $sub_data["id"];
                                                    ?>
                                                            <div class="subject-item mb-3" style="background-color: #f7f9fa;" data-target="#lessons-<?php echo $sid; ?>">
                                                                <!-- SUBJECT BUTTON -->
                                                                <div class="subject-btn bg-white rounded-3 shadow-sm p-3 d-flex justify-content-between align-items-center">
                                                                    <div class="d-flex align-items-center gap-2">
                                                                        <span class="legend-dot orange flex-shrink-0"></span>
                                                                        <strong><?php echo $sub_data["title"]; ?></strong>
                                                                    </div>
                                                                    <div class="d-flex justify-content-center align-items-center flex-shrink-0" style="width: 50px;">
                                                                        <label class="custom-checkbox-wrapper">
                                                                            <input type="checkbox" class="subject-checkbox"
                                                                                <?php
                                                                                if (isset($_SESSION["user"])) {
                                                                                ?>
                                                                                data-student-id="<?php echo $_SESSION["user"]["id"]; ?>"
                                                                                <?php
                                                                                } else {
                                                                                ?>
                                                                                data-student-id="0"
                                                                                <?php
                                                                                }
                                                                                ?>

                                                                                data-subject-id="<?php echo $sid; ?>"
                                                                                data-subject-name="<?php echo $sub_data["title"]; ?>">
                                                                            <span class="checkmark"></span>
                                                                        </label>
                                                                    </div>
                                                                </div>

                                                                <!-- LESSONS -->
                                                                <div class="accordion-collapse collapse mt-2 " style="background-color: #f7f9fa;" id="lessons-<?php echo $sid; ?>">
                                                                    <div class="accordion-body p-0 ms-4">
                                                                        <?php
                                                                        $lrs = Database::search("SELECT * FROM `lesson` WHERE `subject_id` = '" . $sid . "'");
                                                                        if ($lrs->num_rows > 0) {
                                                                            while ($les_data = $lrs->fetch_assoc()) {
                                                                        ?>
                                                                                <div class="bg-white rounded-3 d-flex justify-content-between align-items-center shadow-sm mb-2 p-3">
                                                                                    <div class="d-flex align-items-center gap-2 flex-grow-1 text-truncate">
                                                                                        <span class="dot purple flex-shrink-0"></span>
                                                                                        <strong class="text-truncate" style="max-width: 100%; font-size: 15px;">
                                                                                            <?php echo $les_data["title"]; ?>
                                                                                        </strong>
                                                                                    </div>
                                                                                </div>
                                                                        <?php
                                                                            }
                                                                        } else {
                                                                            echo "<p class='p-3 text-muted ms-4'>No lessons available</p>";
                                                                        }
                                                                        ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                    <?php
                                                        }
                                                    } else {
                                                        echo "<p class='p-3 text-muted'>No subjects available</p>";
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                <?php
                                    }
                                } else {
                                    echo "<p>No courses found</p>";
                                }
                                ?>



                            </div>





                        </div>
                    </div>
                </div>

            </div>
        </div>


        <!-- Ready To Pay Section -->
        <section class="payment-section">
            <div class="container">
                <div class="payment-container">

                    <!-- LEFT SIDE: Ready to Pay -->
                    <div class="ready-to-pay-box">
                        <div class="ready-title-row" style="background:#fff; border-radius:10px; padding:15px 20px; box-shadow:0 2px 6px rgba(0,0,0,0.05); margin-bottom:10px;">
                            <h4 style="margin:0; font-weight:700;">Ready to Pay</h4>
                        </div>

                        <div id="rpay">


                        </div>



                    </div>

                    <!-- RIGHT SIDE: Bank Transfer Details -->
                    <div class="bank-details-box">
                        <h4> <img src="Resources/Icons/bank.png" style="height: 30px;"> Bank Transfer Details</h4>

                        <div style="display: flex; justify-content: center;">
                            <div class="custom-dropdown mb-4" id="bankDropdown" style="width: 250px;">
                                <div class="dropdown-btn">Select Bank</div>
                                <div class="dropdown-list" id="bankList">
                                    <!-- Banks will be loaded here -->
                                </div>
                            </div>
                        </div>

                        <div class="bank-detail">
                            <div><strong>Name :</strong> <span class="fw-bold" id="bankOwnerName">-</span></div>
                            <button class="copy-btn" onclick="copyToClipboard('bankOwnerName', event)"> <img src="Resources/Icons/copy.png" style="height: 20px;"></i></button>
                        </div>

                        <div class="bank-detail">
                            <div><strong>Acc Number :</strong> <span class="fw-bold" id="bankAccNumber">-</span></div>
                            <button class="copy-btn" onclick="copyToClipboard('bankAccNumber', event)"> <img src="Resources/Icons/copy.png" style="height: 20px;"></i></button>
                        </div>

                        <div class="bank-detail">
                            <div><strong>Bank :</strong> <span class="fw-bold" id="bankName">-</span></div>
                            <button class="copy-btn" onclick="copyToClipboard('bankName', event)"> <img src="Resources/Icons/copy.png" style="height: 20px;"></i></button>
                        </div>

                        <div class="bank-detail">
                            <div><strong>Branch :</strong> <span class="fw-bold" id="bankBranch">-</span></div>
                            <button class="copy-btn" onclick="copyToClipboard('bankBranch', event)"> <img src="Resources/Icons/copy.png" style="height: 20px;"></i></button>
                        </div>

                        <a style="text-decoration: none;" href="https://wa.me/94753595844"> <button class="bank-submit-btn">
                                <img src="Resources/Icons/send.png" style="height: 20px;">Submit Slip
                            </button>
                        </a>

                        <p class="bank-footer-text" style="text-align: justify;">
                            When sending the bank slip via WhatsApp, Please send the name you registered for the e-Exam.lk and your National Identity Card number.
                        </p>
                    </div>

                </div>
            </div>
        </section>


        <!--Summary Section  -->
        <div class="container">
            <div class="main-wrapper">
                <div class="info-card mb-2">
                    <div class="d-flex justify-content-between align-items-center flex-wrap">
                        <div class="mb-2 mb-md-0">
                            <h5 class="subjects-selected mb-0">3 Subjects Selected</h5>
                        </div>
                        <div class="text-end">
                            <h5 class="total-amount-header">TOTAL AMOUNT</h5>
                            <p class="total-amount-value mb-0">LKR : 0.00</p>
                        </div>
                    </div>
                </div>

                <div class="row align-items-center">
                    <div class="col-lg-7 col-md-12 mb-2 mb-lg-0">
                        <div class="card text-card" style="border: none;">
                            <div class="card-body">
                                <!-- Pending Requests Section -->
                                <div id="pendingRequestsSection" style="display: none;">
                                    <h6 class="fw-bold mb-3 text-danger">
                                        <i class="fa-solid fa-clock me-2"></i>Pending Requests
                                    </h6>
                                    <div id="pendingRequestsList" class="mb-3">
                                        <!-- Pending requests will be loaded here -->
                                    </div>
                                </div>
                                <div id="noPendingRequests" class="text-muted">
                                    <small>No pending requests</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-5 col-md-12">
                        <div class="button-box" style="background:#fff; border-radius:10px; box-shadow:0 2px 6px rgba(0,0,0,0.05); padding:30px;">

                            <div class="d-flex justify-content-between align-items-center button-group w-100 position-relative">

                                <button onclick="sendreq(<?php echo isset($_SESSION['user']['id']) ? $_SESSION['user']['id'] : ''; ?>)" id="requestBtn" class="btn btn-custom btn-request flex-fill position-relative">Request</button>
                                <button class="btn btn-custom btn-cancel flex-fill me-3" onclick="cancelRequests();">Cancel</button>

                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </div>


        <?php include "Footer.php"; ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script src="Backend/Js/details_page.js"></script>
        <script src="Backend/Js/readyToPay.js"></script>


        <script>
            // Load banks on page load
            async function loadBanks() {
                try {
                    const res = await fetch("Backend/Process/LoadBanks.php", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json"
                        }
                    });

                    if (res.ok) {
                        const json = await res.json();
                        if (json.status && json.data) {
                            const bankList = document.getElementById('bankList');
                            bankList.innerHTML = '';

                            json.data.forEach(bank => {
                                const bankItem = document.createElement('div');
                                bankItem.textContent = bank.name;
                                bankItem.setAttribute('data-value', bank.id);
                                bankItem.setAttribute('data-bank-id', bank.id);
                                bankList.appendChild(bankItem);
                            });

                            // Setup dropdown functionality
                            setupBankDropdown();
                        }
                    }
                } catch (err) {
                    console.error("Error loading banks:", err);
                }
            }

            // Load bank details when bank is selected
            async function loadBankDetails(bankId) {
                try {
                    const res = await fetch("Backend/Process/LoadBankDetails.php", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json"
                        },
                        body: JSON.stringify({
                            bank_id: bankId
                        })
                    });

                    if (res.ok) {
                        const json = await res.json();
                        if (json.status && json.data) {
                            document.getElementById('bankOwnerName').textContent = json.data.owner_name || '-';
                            document.getElementById('bankAccNumber').textContent = json.data.acc_number || '-';
                            document.getElementById('bankName').textContent = json.data.bank_name || '-';
                            document.getElementById('bankBranch').textContent = json.data.branch || '-';
                        } else {
                            // Clear fields if no data found
                            document.getElementById('bankOwnerName').textContent = '-';
                            document.getElementById('bankAccNumber').textContent = '-';
                            document.getElementById('bankName').textContent = '-';
                            document.getElementById('bankBranch').textContent = '-';
                        }
                    }
                } catch (err) {
                    console.error("Error loading bank details:", err);
                }
            }

            // Setup bank dropdown functionality
            function setupBankDropdown() {
                const dropdown = document.getElementById('bankDropdown');
                const btn = dropdown.querySelector('.dropdown-btn');
                const list = dropdown.querySelector('.dropdown-list');
                const items = list.querySelectorAll('div');

                // Toggle dropdown
                btn.addEventListener('click', () => {
                    dropdown.classList.toggle('active');
                });

                // Select option
                items.forEach(item => {
                    item.addEventListener('click', () => {
                        const bankId = item.getAttribute('data-bank-id');
                        const bankName = item.textContent;
                        btn.textContent = bankName;
                        dropdown.classList.remove('active');

                        // Load bank details
                        if (bankId) {
                            loadBankDetails(bankId);
                        }
                    });
                });

                // Close on outside click
                document.addEventListener('click', (e) => {
                    if (!dropdown.contains(e.target)) {
                        dropdown.classList.remove('active');
                    }
                });
            }

            // Copy to clipboard function
            function copyToClipboard(elementId, event) {
                const element = document.getElementById(elementId);
                const text = element.textContent.trim();

                if (text && text !== '-') {
                    navigator.clipboard.writeText(text).catch(err => {
                        console.error('Failed to copy:', err);
                    });
                }
            }

            // Load banks when page loads
            loadBanks();


            // Get all copy buttons
            const copyButtons = document.querySelectorAll('.copy-btn');

            copyButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const textToCopy = button.previousElementSibling.innerText
                        .replace('Name :', '')
                        .replace('Acc Number :', '')
                        .replace('Bank :', '')
                        .replace('Branch :', '')
                        .trim();

                    navigator.clipboard.writeText(textToCopy)
                        .then(() => {
                            // Keep the original icon (image) visible — don't replace it
                            // Add a temporary tooltip instead
                            const tooltip = document.createElement('span');
                            tooltip.textContent = 'Copied!';
                            tooltip.style.position = 'absolute';
                            tooltip.style.top = '-25px';
                            tooltip.style.left = '50%';
                            tooltip.style.transform = 'translateX(-50%)';
                            tooltip.style.background = '#ff4d4f';
                            tooltip.style.color = '#fff';
                            tooltip.style.padding = '2px 6px';
                            tooltip.style.fontSize = '12px';
                            tooltip.style.borderRadius = '4px';
                            tooltip.style.whiteSpace = 'nowrap';
                            tooltip.style.zIndex = '10';
                            button.style.position = 'relative';
                            button.appendChild(tooltip);

                            setTimeout(() => tooltip.remove(), 1500);
                        })
                        .catch(err => {
                            console.error('Copy failed:', err);
                        });
                });
            });


            document.addEventListener('DOMContentLoaded', function() {

                // --- Toggle course accordions ---
                const courseButtons = document.querySelectorAll('.course-btn');
                courseButtons.forEach(button => {
                    button.addEventListener('click', function(e) {
                        const target = document.querySelector(button.getAttribute('data-target'));
                        if (!target) return;
                        target.classList.toggle('show');
                    });
                });

                // --- Toggle lessons when clicking a subject ---
                const subjectItems = document.querySelectorAll('.subject-item');

                subjectItems.forEach(item => {
                    const subjectBtn = item.querySelector('.subject-btn');
                    const lessons = document.querySelector(item.getAttribute('data-target'));

                    subjectBtn.addEventListener('click', function(e) {
                        // prevent checkbox click from toggling
                        if (e.target.tagName.toLowerCase() === 'input') return;

                        if (lessons) {
                            lessons.classList.toggle('show');
                        }
                    });
                });

                // --- Checkbox functionality ---
                const subjectCheckboxes = document.querySelectorAll('.subject-checkbox');

                // Function to update subject count
                function updateSubjectCount() {
                    const checkedCount = document.querySelectorAll('.subject-checkbox:checked').length;
                    const countElement = document.querySelector('.subjects-selected');
                    if (countElement) {
                        countElement.textContent = checkedCount + (checkedCount === 1 ? ' Subject Selected' : ' Subjects Selected');
                    }
                }

                // Initial count update
                updateSubjectCount();

                subjectCheckboxes.forEach(checkbox => {
                    checkbox.addEventListener('change', function() {
                        const parent = this.closest('.subject-item');
                        parent.classList.toggle('subject-selected', this.checked);
                        // Update count when checkbox changes
                        updateSubjectCount();
                    });
                });

                // Stop event propagation on checkbox wrapper
                const checkboxWrappers = document.querySelectorAll('.custom-checkbox-wrapper');
                checkboxWrappers.forEach(wrapper => {
                    wrapper.addEventListener('click', function(event) {
                        event.stopPropagation();
                    });
                });
            });
        </script>

</body>

</html>