<?php
session_start();
include "Backend/Process/connection.php";

// Always reset exam session when starting a new exam so students can reattempt anytime
if (isset($_GET["subject_id"])) {
    unset($_SESSION['exam_start_time']);
    unset($_SESSION['exam_duration']);
    unset($_SESSION['exam_completed']);
    unset($_SESSION['exam_result']);
}

// Prevent browser caching
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Cache-Control: post-check=0, pre-check=0', false);
header('Pragma: no-cache');
header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');

$subject_id = $_GET["subject_id"];

$rs = Database::search("SELECT * FROM `subject` WHERE id = '$subject_id'");
$row = $rs->fetch_assoc();

$subject_name = $row["title"];

// Initialize timer if not set
if (!isset($_SESSION['exam_start_time'])) {
    $_SESSION['exam_start_time'] = time();
    $_SESSION['exam_duration'] = 5; // 5 seconds for rapid timeout testing
}

// Calculate remaining time
$elapsed_time = time() - $_SESSION['exam_start_time'];
$remaining_time = max(0, $_SESSION['exam_duration'] - $elapsed_time);

// If time is up, redirect to results
if ($remaining_time <= 0) {
    $_SESSION['exam_completed'] = true;
    header('Location: FinalResults.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sri Lanka’s First Digital Exam & Exam Practice Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="Resources/Logo/icon.png">

    <style>
        body {
            background-color: #f5f5f5;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .exam-header {
            background-color: white;
            border-radius: 10px;
            padding: 20px 25px;
            margin-bottom: 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
        }

        .exam-header h5 {
            flex: 1 1 70%;
            font-weight: 600;
            color: #d32f2f;
            margin: 0;
            word-break: break-word;
        }

        .timer {
            background-color: #e53935;
            color: white;
            padding: 8px 15px;
            border-radius: 8px;
            font-weight: 500;
            white-space: nowrap;
            flex-shrink: 0;
            height: fit-content;
        }

        .question-card {
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            padding: 20px;
            display: inline-block;
            width: 100%;
        }

        .question-options label {
            display: block;
            margin-bottom: 10px;
            cursor: pointer;
            padding: 5px 8px;
            border-radius: 6px;
        }

        .question-options input[type="radio"] {
            accent-color: #e53935;
            /* makes the radio circle red */
            cursor: pointer;
        }

        .question-options input[type="radio"]:checked+label,
        .question-options label:has(input[type="radio"]:checked) {
            background-color: #d8faedff;
            border: 1px solid #1eaa80ff;
            border-radius: 6px;
            padding: 5px 8px;
            color: #e53935;
            font-weight: 500;
            transition: 0.2s ease-in-out;
        }

        .question-card p {
            margin-bottom: 20px;
        }

        .text-end.mt-4 {
            margin-top: 30px !important;
        }

        .next-btn {
            background-color: #e53935;
            color: white;
            border: none;
            padding: 8px 25px;
            border-radius: 6px;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .next-btn:hover {
            background-color: #c62828;
        }

        .question-nav {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(45px, 1fr));
            gap: 8px;
            background-color: white;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
            padding: 15px;
            width: 100%;
            box-sizing: border-box;
            height: 100%;
            min-height: 400px;
            overflow-y: auto;
        }

        .question-nav button {
            width: 100%;
            aspect-ratio: 1 / 1;
            border: 1px solid #ddd;
            border-radius: 8px;
            background-color: #f8f9fa;
            transition: 0.2s;
            margin: 0;
        }

        .question-nav button.active {
            background-color: #e53935;
            color: white;
        }

        .question-nav button:hover {
            background-color: #e0e0e0;
        }

        @media (max-width: 768px) {
            .exam-header {
                flex-direction: column;
                align-items: flex-start;
                position: relative;
            }

            .exam-header h5 {

                margin-bottom: 10px;
                text-align: left;
                font-size: 20px;
                line-height: 1.3;
            }

            .timer {

                top: 20px;
                right: 25px;
                transform: none;
                height: auto;
                width: auto;
            }

            .question-nav {
                grid-template-columns: repeat(auto-fit, minmax(38px, 1fr));
            }

            .question-nav button {
                font-size: 14px;
            }

            .question-card p {
                font-size: 15px;
                line-height: 1.4;
            }
        }

        .timer {
            font-size: 1.3rem;
            font-weight: bold;
            color: #e63946;
            background: #fff3f3;
            padding: 6px 15px;
            border-radius: 10px;
            box-shadow: 0 0 5px rgba(255, 0, 0, 0.2);
        }

        footer {
            position: relative;
            bottom: 0;
            left: 0;
            width: 100%;
            background-color: #fff;
            box-shadow: 0 -1px 5px rgba(0, 0, 0, 0.1);
            z-index: 1000;
        }
    </style>
</head>

<body>

    <!-- Header -->
    <div class="container exam-header d-flex justify-content-between align-items-center flex-wrap">
        <h5><em><?php echo ($subject_name . " Examination") ?></em></h5>
        <div class="timer">
            <?php
            $remaining_time = 2 * 3600; // 2 hours in seconds

            $hours = floor($remaining_time / 3600);
            $minutes = floor(($remaining_time % 3600) / 60);
            $seconds = $remaining_time % 60;

            printf("%02d:%02d:%02d", $hours, $minutes, $seconds);
            ?>
        </div>
    </div>

    <!-- Main content -->
    <div class="container mt-5 mb-4">
        <div class="row g-3">
            <!-- Question Section -->
            <div class="col-12 col-lg-9">
                <div class="question-card">
                    <p class="mb-4 fw-medium fs-5">
                        Which HTML element and attributes are used to attach an external CSS file to an HTML document?
                    </p>
                    <div class="question-options">

                    </div>
                    <div class="text-end mt-4 d-flex justify-content-between">
                        <button class="btn btn-secondary prev-btn">Back</button>
                        <button class="btn btn-primary next-btn">Next</button>
                    </div>
                </div>
            </div>

            <!-- Question Navigation -->
            <div class="col-12 col-lg-3 mb-5">
                <div class="question-nav d-grid">
                    <?php for ($i = 1; $i <= 50; $i++): ?>
                        <button class="<?php echo $i == 1 ? 'active' : ''; ?>"><?php echo $i; ?></button>
                    <?php endfor; ?>
                </div>
            </div>
        </div>

    </div>



    <?php include 'footer.php'; ?>
    <script src="Backend/Js/Paper.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


</body>

</html>