<?php
session_start();
include "Backend/Process/connection.php";

// Retrieve result from session
$result = $_SESSION["exam_result"] ?? null;
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Final Result</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="common.css">

    <style>
        body {
            background: white;
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .main-container {
            max-width: 900px;
            margin: 0 auto;
            padding: 20px;
        }

        .result-header {
            background: linear-gradient(135deg, rgba(255,255,255,0.95) 0%, rgba(255,255,255,0.9) 100%);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            padding: 40px;
            margin: 30px 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border: 1px solid rgba(255,255,255,0.2);
            position: relative;
            overflow: hidden;
        }

        .result-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
        }

        .result-header h4 {
            color: var(--primary);
            font-weight: 700;
            margin: 0;
            font-size: 2rem;
            text-transform: uppercase;
            letter-spacing: 2px;
        }

        .score-box {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
            font-weight: bold;
            border-radius: 15px;
            padding: 15px 25px;
            font-size: 1.2rem;
            box-shadow: 0 10px 25px rgba(220, 38, 38, 0.3);
            transform: translateY(0);
            transition: transform 0.3s ease;
        }

        .score-box:hover {
            transform: translateY(-3px);
        }

        .content-grid {
            display: flex;
            flex-direction: column;
            gap: 30px;
            margin: 30px 0;
        }

        .percentage-section {
            background: rgba(255,255,255,0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255,255,255,0.2);
            text-align: center;
        }

        .percentage-display {
            position: relative;
        }

        .branding {
            position: absolute;
            top: -10px;
            right: 0;
            font-size: 0.9rem;
            color: var(--secondary);
            font-weight: 600;
            opacity: 0.7;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .percentage-label {
            display: block;
            font-size: 1.2rem;
            color: #666;
            margin-bottom: 30px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 2px;
        }

        .chart-container {
            position: relative;
            width: 250px;
            height: 250px;
            margin: 0 auto 30px;
        }

        .circular-chart {
            width: 250px;
            height: 250px;
            transform: rotate(-90deg);
            filter: drop-shadow(0 10px 20px rgba(0,0,0,0.1));
        }

        .circle-bg {
            fill: none;
            stroke: #f0f0f0;
            stroke-width: 20;
        }

        .circle-progress {
            fill: none;
            stroke-width: 20;
            stroke-linecap: round;
            transition: stroke-dashoffset 1.5s ease-in-out;
            animation: progressAnimation 2s ease-out;
        }

        @keyframes progressAnimation {
            from {
                stroke-dashoffset: 565.48;
            }
        }

        .percentage-text {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-size: 3rem;
            font-weight: 800;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
        }

        .grade-badge {
            display: inline-block;
            padding: 12px 30px;
            border-radius: 30px;
            font-weight: bold;
            font-size: 1.2rem;
            margin-top: 20px;
            text-transform: uppercase;
            letter-spacing: 1px;
            animation: bounceIn 1s ease-out;
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
        }

        @keyframes bounceIn {
            0% { transform: scale(0); opacity: 0; }
            50% { transform: scale(1.1); }
            100% { transform: scale(1); opacity: 1; }
        }

        .grade-excellent { background: linear-gradient(135deg, #10B981, #059669); color: white; }
        .grade-good { background: linear-gradient(135deg, #3B82F6, #2563EB); color: white; }
        .grade-average { background: linear-gradient(135deg, #F59E0B, #D97706); color: white; }
        .grade-poor { background: linear-gradient(135deg, #EF4444, #DC2626); color: white; }

        .answers-section {
            background: rgba(255,255,255,0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255,255,255,0.2);
        }

        .answers-container {
            max-width: 100%;
            margin: 0;
        }

        .answers-container h6 {
            font-weight: 700;
            margin-bottom: 25px;
            color: #333;
            font-size: 1.3rem;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .answer-review {
            background-color: white;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
            padding: 25px;
            margin-bottom: 20px;
            border-left: 6px solid #e0e0e0;
            position: relative;
            transition: all 0.3s ease;
        }

        .answer-review:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
        }

        .answer-review.correct {
            border-left-color: #43a047;
        }

        .answer-review.wrong {
            border-left-color: var(--primary);
        }

        .question-number {
            background: linear-gradient(45deg, var(--primary), var(--secondary));
            color: white;
            font-weight: bold;
            border-radius: 50%;
            height: 35px;
            width: 35px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 16px;
            position: absolute;
            top: 20px;
            left: 20px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.2);
        }

        .answer-review h5 {
            font-size: 16px;
            margin-bottom: 15px;
            font-weight: 600;
            margin-left: 50px;
            line-height: 1.4;
        }

        .answer-review label {
            display: block;
            margin-bottom: 10px;
            font-size: 15px;
            padding-left: 15px;
            line-height: 1.4;
        }

        .correct-answer {
            color: #43a047;
            font-weight: 500;
        }

        .wrong-answer {
            color: var(--secondary);
            font-weight: 500;
        }

        .icon {
            font-weight: bold;
            font-size: 18px;
        }

        .icon.correct {
            color: #43a047;
        }

        .action-buttons {
            display: flex;
            gap: 20px;
            justify-content: center;
            margin-top: 40px;
        }

        .action-buttons button {
            padding: 15px 40px;
            border: none;
            border-radius: 50px;
            font-weight: 700;
            font-size: 16px;
            cursor: pointer;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            position: relative;
            overflow: hidden;
        }

        .action-buttons button::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.5s;
        }

        .action-buttons button:hover::before {
            left: 100%;
        }

        .btn-done {
            background: linear-gradient(135deg, #FF6B6B, #DC2626, #B91C1C);
            color: white;
            border: 2px solid #DC2626;
        }

        .btn-done:hover {
            background: linear-gradient(135deg, #DC2626, #B91C1C, #991B1B);
            transform: translateY(-3px);
            box-shadow: 0 15px 35px rgba(220, 38, 38, 0.4);
        }

        .btn-home {
            background: linear-gradient(135deg, #60A5FA, #3B82F6, #2563EB);
            color: white;
            border: 2px solid #3B82F6;
        }

        .btn-home:hover {
            background: linear-gradient(135deg, #3B82F6, #2563EB, #1D4ED8);
            transform: translateY(-3px);
            box-shadow: 0 15px 35px rgba(59, 130, 246, 0.4);
        }

        @media (max-width: 968px) {
            .content-grid {
                grid-template-columns: 1fr;
            }
            
            .result-header {
                flex-direction: column;
                text-align: center;
                gap: 20px;
            }
            
            .result-header h4 {
                font-size: 1.5rem;
            }
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 10px;
            }
            
            .result-header, .percentage-section, .answers-section {
                padding: 25px;
                margin: 20px 0;
            }
            
            .chart-container {
                width: 200px;
                height: 200px;
            }
            
            .circular-chart {
                width: 200px;
                height: 200px;
            }
            
            .percentage-text {
                font-size: 2.5rem;
            }
            
            .action-buttons {
                flex-direction: column;
                align-items: center;
            }
            
            .action-buttons button {
                width: 200px;
            }
        }
    </style>
</head>

<body>

    <?php if (!$result): ?>
        <div class="container my-5">
            <div class="alert alert-info text-center shadow-sm">
                No exam answers found. Please attempt the quiz first.
            </div>
        </div>
    <?php else: ?>

        <div class="main-container">
            <!-- Header -->
            <div class="result-header">
                <h4>Final Result</h4>
                <div class="score-box">
                    <?php echo htmlspecialchars($result["correct"]) . "/" . htmlspecialchars($result["total"]); ?>
                </div>
            </div>

            <!-- Content Grid -->
            <div class="content-grid">
                <!-- Percentage Section -->
                <div class="percentage-section">
                    <div class="percentage-display">
                        <div class="branding">e-Exam.lk</div>
                        <span class="percentage-label">Performance Score</span>
                        
                        <div class="chart-container">
                            <svg class="circular-chart" viewBox="0 0 200 200">
                                <circle class="circle-bg" cx="100" cy="100" r="90"></circle>
                                <circle class="circle-progress" cx="100" cy="100" r="90"
                                        stroke="<?php 
                                            $percentage = floatval($result["percentage"]);
                                            if ($percentage <= 15) {
                                                echo '#EF4444'; // Red
                                            } elseif ($percentage <= 30) {
                                                echo '#F97316'; // Orange  
                                            } elseif ($percentage <= 75) {
                                                echo '#EAB308'; // Yellow
                                            } else {
                                                echo '#22C55E'; // Green
                                            }
                                        ?>"
                                        stroke-dasharray="565.48"
                                        stroke-dashoffset="<?php echo 565.48 - (565.48 * $result["percentage"] / 100); ?>">
                                </circle>
                            </svg>
                            <div class="percentage-text" style="color: <?php 
                                if ($percentage <= 15) {
                                    echo '#EF4444'; // Red
                                } elseif ($percentage <= 30) {
                                    echo '#F97316'; // Orange  
                                } elseif ($percentage <= 75) {
                                    echo '#EAB308'; // Yellow
                                } else {
                                    echo '#22C55E'; // Green
                                }
                            ?>;"><?php echo htmlspecialchars($result["percentage"]); ?>%</div>
                        </div>
                        
                        <?php
                        $percentage = floatval($result["percentage"]);
                        $grade_class = '';
                        $grade_text = '';
                        
                        if ($percentage >= 80) {
                            $grade_class = 'grade-excellent';
                            $grade_text = 'Excellent!';
                        } elseif ($percentage >= 60) {
                            $grade_class = 'grade-good';
                            $grade_text = 'Good Job!';
                        } elseif ($percentage >= 40) {
                            $grade_class = 'grade-average';
                            $grade_text = 'Average';
                        } else {
                            $grade_class = 'grade-poor';
                            $grade_text = 'Need Improvement';
                        }
                        ?>
                        
                        <div class="grade-badge <?php echo $grade_class; ?>">
                            <?php echo $grade_text; ?>
                        </div>
                    </div>
                    
                    <div class="action-buttons">
                        <button class="btn-done" onclick="window.location.href='Dashboard.php'">Done</button>
                        <button class="btn-home" onclick="window.location.href='index.php'">Go to Home</button>
                    </div>
                </div>

                <!-- Answers Section -->
                <div class="answers-section">
                    <div class="answers-container">
                        <h6>Check Your Answers</h6>

                        <?php foreach ($result["review"] as $r): ?>
                            <?php
                            $isCorrect = $r["is_correct"];
                            $questionNo = $r["question_no"];
                            $question = $r["question"];
                            ?>
                            <div class="answer-review <?php echo $isCorrect ? 'correct' : 'wrong'; ?>">
                                <span class="question-number"><?php echo $questionNo; ?></span>
                                <h5><?php echo htmlspecialchars($question); ?></h5>

                                <?php
                                $opts = ["a", "b", "c", "d"];
                                foreach ($opts as $opt):
                                    $text = $r["option_" . $opt];
                                    $correctOpt = strtolower($r["correct_option"]);
                                    $selectedOpt = strtolower($r["selected_option"] ?? "");
                                    $class = "";
                                    $icon = "";

                                    if ($correctOpt === $opt) {
                                        $class = "correct-answer";
                                        $icon = '<span class="icon correct">✔</span>';
                                    }

                                    if ($selectedOpt === $opt && $selectedOpt !== $correctOpt) {
                                        $class = "wrong-answer";
                                        $icon = '<span class="icon wrong">✖</span>';
                                    }
                                ?>
                                    <label class="<?php echo $class; ?>">
                                        <?php echo strtoupper($opt) . ". " . htmlspecialchars($text) . " " . $icon; ?>
                                    </label>
                                <?php endforeach; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>

    <?php endif; ?>

    <?php include 'footer.php'; ?>
    <script src="Backend/Js/Result.js"></script>
</body>
</html>