<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Modern Footer</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <link rel="stylesheet" href="common.css">

  <style>
    footer {
      background: #f2f2f2ff;
      padding: 50px 0 0;

    }

    footer h5 {
      font-weight: 700;
      margin-bottom: 15px;
      color: #e53935;
    }

    footer h5 span {
      color: var(--gray);
    }

    footer p {
      font-size: 14px;
      line-height: 1.5;
      margin-bottom: 0;
    }

    .footer-links a {
      display: block;
      color: #2c3e50;
      text-decoration: none;
      margin-bottom: 6px;
      transition: color 0.3s ease;
      font-size: 14px;
    }

    .footer-links a:hover {
      color: #e53935;
    }

    .social-icons a {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      width: 35px;
      height: 35px;
      background: #e0e0e0;
      color: #2c3e50;
      border-radius: 50%;
      margin-right: 8px;
      font-size: 16px;
      transition: background 0.3s ease, color 0.3s ease;
    }

    .social-icons a {
      text-decoration: none !important;
    }

    .social-icons a:hover {
      background: #e53935;
      color: #ffffff;
      transform: scale(1.1);
    }

    .social-icons a:hover i {
      color: #ffffff;
    }

    .footer-bottom {
      background: #e53935;
      color: #fff;
      text-align: center;
      padding: 12px 10px;
      font-size: 14px;
      margin-top: 30px;
    }

    @media (max-width: 576px) {
      .social-icons a {
        margin-right: 4px;
        width: 30px;
        height: 30px;
        font-size: 14px;
      }
    }
  </style>
</head>

<body>

  <footer>
    <div class="container">
      <div class="row gy-5">
        <!-- Column 1 -->
        <div class="col-12 col-md-6 col-lg-3 col-xl-3 ">
          <a href="index.php"> <img src="Resources/Logo/logo.png" class="mb-2" style="height: 50px;"></a>
          <p style="text-align: justify;">Eexam.lk is Sri Lanka’s First <span class="fw-bold">Digital Exam & Exam Practice Platform,</span> helping students practice computer-based exams with confidence. Our goal is to make learning accessible, stress-free, and future-ready.</p>
        </div>

        <!-- Column 2 -->
        <div class="col-12 col-md-6 col-lg-3 col-xl-3 footer-links">
          <h5>Quick Links</h5>
          <a href="index.php">Home</a>
          <a href="Dashboard.php">My Courses</a>
          <a href="AboutUs.php">About Us</a>

        </div>

        <!-- Column 3 -->
        <div class="col-12 col-md-6 col-lg-2 col-xl-3 footer-links">
          <h5>Student</h5>
          <a href="Register.php">Account</a>
          <a href="Login.php">Login</a>
          <a href="#">How to use</a>
        </div>

        <!-- Column 4 -->
        <div class="col-12 col-md-6 col-lg-4 col-xl-3 ">
          <h5>Contact</h5>

          <div class="social-icons mb-3">
            <!-- WhatsApp -->
            <a href="https://wa.me/94753595844" target="_blank">
              <i class="fab fa-whatsapp"></i>
            </a>

            <!-- Facebook -->
            <a href="https://www.facebook.com/share/17RjGJfUsv/" target="_blank">
              <i class="fab fa-facebook-f"></i>
            </a>

            <!-- LinkedIn (placeholder) -->
            <a href="#" target="_blank">
              <i class="fab fa-linkedin-in"></i>
            </a>

            <!-- TikTok -->
            <a href="https://www.tiktok.com/@eexam.lk?_r=1&_t=ZS-91Rc3a2G1k0" target="_blank">
              <i class="fab fa-tiktok"></i>
            </a>

            <!-- Instagram (placeholder) -->
            <a href="#" target="_blank">
              <i class="fab fa-instagram"></i>
            </a>
          </div>

          <!-- Email -->
          <p>
            <img src="Resources/Icons/email.png" style="height: 15px;">
            <a style="text-decoration: none;color:#2c3e50;" href="https://mail.google.com/mail/?view=cm&fs=1&to=team.eexam@gmail.com" target="_blank">
              team.eexam@gmail.com
            </a>
          </p>

          <!-- Hotline -->
          <p>
            <img src="Resources/Icons/hotline.png" style="height: 15px;">
            <a href="https://wa.me/94753595844"
              target="_blank"
              style="text-decoration:none; color:#2c3e50;">
              075 359 5844
            </a>
          </p>
        </div>

      </div>
    </div>

    <div class="footer-bottom">
      © <?php 
            $currentYear = date("Y"); 
            $startYear = 2025;
            echo ($currentYear > $startYear) ? "$startYear-$currentYear" : $startYear; 
          ?> All Rights Reserved @ e-Exam.lk | Designed & Developed by <strong>EVOTZA Pvt Ltd</strong>
    </div>
  </footer>

</body>

</html>