
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Navbar - Online Akura</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="common.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <style>
        .login-btn {
            height: 40px;
            width: 120px;
            background: linear-gradient(135deg, var(--primary), #f43f3f);
            color: #fff;
            font-weight: 700;
            border-radius: 6px;
            border: none;
            transition: 0.3s;
        }

        .login-btn:hover {
            background: linear-gradient(135deg, #b71c1c, var(--primary));
        }

        .navbar-nav .nav-link {
            font-weight: 700;
            margin: 0 10px;
            color: var(--black);
            transition: color 0.3s;
        }

        .navbar-nav .nav-link.active {
            color: var(--primary) !important;
            font-weight: 700;


        }

        .navbar-nav .nav-link:hover {
            color: var(--secondary);
        }

        .icon-bg {
            background: #fff !important;
            padding: 8px;
            border-radius: 6px;
        }

        /* Hover effect for overlay links */
        #profileOverlay a:hover,
        #desktopProfileOverlay a:hover {
            background: rgba(244, 63, 63, 0.1);
            color: var(--secondary) !important;
            text-decoration: none;
            transition: 0.3s ease;
        }

        /* --- Profile Modal Form Styling --- */
        #profileModal .form-control {
            border-radius: 8px;
            height: 45px;
            padding: 10px 15px;
            font-size: 15px;
        }

        #profileModal .row.g-3 {
            gap: 0 !important;
        }

        #profileModal .col-md-5,
        #profileModal .mb-3,
        #profileModal .input-group {
            margin-bottom: 15px !important;
        }

        #profileModal form {
            max-width: 450px;
            margin: auto;
        }

        /* Save Details Button Styling */
        .save-btn {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            border: none;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .save-btn:hover {
            background: linear-gradient(135deg, var(--secondary), var(--primary));
            transform: translateY(-3px);
            box-shadow: 0 4px 10px rgba(244, 63, 63, 0.3);
        }

        #mobileProfile img {
            width: 100% !important;
            height: 100% !important;
            object-fit: cover !important;
            object-position: center !important;
            display: block !important;
        }

         @media (max-width: 576px) {

        /* Reduce logo size */
        nav img {
            height: 28px !important;
        }

        /* Make Login button smaller */
        .login-btn {
            height: 32px !important;
            width: 90px !important;
            font-size: 13px !important;
        }

        /* Make toggle (hamburger) icon smaller */
        .fa-bars {
            font-size: 1.5rem !important;
        }

        /* Adjust profile picture small size */
        #mobileProfile {
            width: 38px !important;
            height: 38px !important;
        }

        /* Reduce greeting text size */
        .fw-bold {
            font-size: 15px !important;
        }

        /* Reduce navbar padding */
        
        /* Prevent modal title from shrinking on small screens */
        #profileModalLabel {
            font-size: 1.6rem !important;
        }
    }
    </style>
   
</head>

<body>

    <!-- Navbar -->
    <div class="fixed-top">
        <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm  ">
            <div class="container">
                <a href="index.php"><img src="Resources/Logo/logo.png" style="height: 40px;"></a>

                <!-- Mobile Screen -->
                <div class="d-flex d-lg-none align-items-center ms-auto me-2 position-relative">
                    <div class="d-block">
                        <div class="d-flex align-items-center justify-content-center">
                            <h5 class="fw-bold mb-0 me-1 mt-2">
                                <?php
                                if (isset($_SESSION["user"])) {
                                    $data = $_SESSION["user"];
                                ?>
                                    <span style="color:var(--secondary);">Hi,</span>
                                    <span style="color:var(--black);"><?php echo $data["firstName"]; ?></span>
                                <?php
                                } else {
                                ?>
                                    <a style="text-decoration: none;" href="login.php"> <button class="login-btn d-block">Log in</button> </a>
                                <?php
                                }
                                ?>
                            </h5>

                            <?php
                            if (isset($_SESSION["user"])) {
                            ?>
                                <div id="mobileProfile" style="width:45px;height:45px;border-radius:8px;overflow:hidden;
                                    background:linear-gradient(135deg,#f43f3f,var(--primary));
                                    color:#fff;font-weight:700;
                                    display:flex;align-items:center;justify-content:center;
                                    font-size:22px;margin-left:10px;cursor:pointer;">
                                    <img src="<?php echo isset($_SESSION['user']['profile_img']) && !empty($_SESSION['user']['profile_img']) ? $_SESSION['user']['profile_img'] : 'Resources/Images/Profile.jpg'; ?>" alt="Profile" style="width:100%;height:100%;object-fit:cover;">
                                </div>
                            <?php
                            }
                            ?>
                        </div>

                        <div id="profileOverlay" style="display:none; position:absolute; top:50px; right:0; background:white; box-shadow:0 4px 10px rgba(0,0,0,0.15); border-radius:8px; padding:10px 0; width:150px; z-index:1000;">
                            <a href="#" data-bs-toggle="modal" data-bs-target="#profileModal" style="display:block; padding:8px 15px; color:var(--black); text-decoration:none; font-weight:600;">View Profile</a>
                            <a onclick="signOut();" style="display:block; padding:8px 15px; color:var(--black); text-decoration:none; font-weight:600;">Sign out</a>
                        </div>
                    </div>
                </div>
                <!-- Mobile Screen -->

                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        const profileBtn = document.getElementById('mobileProfile');
                        const overlay = document.getElementById('profileOverlay');

                        profileBtn.addEventListener('click', function(e) {
                            e.stopPropagation();
                            overlay.style.display = (overlay.style.display === 'block') ? 'none' : 'block';
                        });

                        document.addEventListener('click', function() {
                            overlay.style.display = 'none';
                        });
                    });
                </script>

                <button class=" d-block d-lg-none border-0 icon-bg mt-2" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                    <span><i class="fa-solid fa-bars fa-2x"></i></span>
                </button>

                <div class="collapse navbar-collapse justify-content-center" id="navbarNav">
                    <ul class="navbar-nav me-3 ">
                        <li class="nav-item">
                            <a class="nav-link" href="index.php">Home</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="Dashboard.php">Dashboard</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="AboutUs.php">About Us</a>
                        </li>
                    </ul>
                </div>


                <!-- Large Screen -->
                <div class="d-none d-lg-flex flex-column align-items-center position-relative">
                    <div class="d-block ">
                        <div class="d-flex align-items-center justify-content-center">
                            <h5 class="fw-bold mb-0 me-3">
                                <?php

                                if (isset($_SESSION["user"])) {
                                    $data = $_SESSION["user"];
                                ?>
                                    <span style="color:var(--secondary);">Hi,</span>
                                    <span style="color:var(--black);"><?php echo $data["firstName"]; ?></span>


                                <?php
                                } else {
                                ?>
                                    <a style="text-decoration: none;" href="login.php"> <button class="login-btn d-block">Log in</button> </a>

                                <?php
                                }
                                ?>

                            </h5>

                            <?php
                            if (isset($_SESSION["user"])) {
                            ?>
                                <div id="desktopProfile" style="width:45px;height:45px;border-radius:8px;overflow:hidden;
                                    background:linear-gradient(135deg,#f43f3f,var(--primary));
                                    color:#fff;font-weight:700;
                                    display:flex;align-items:center;justify-content:center;
                                    font-size:22px;margin-left:10px;cursor:pointer;">
                                    <img src="<?php echo isset($_SESSION['user']['profile_img']) && !empty($_SESSION['user']['profile_img']) ? $_SESSION['user']['profile_img'] : 'Resources/Images/Profile.jpg'; ?>" alt="Profile" style="width:100%;height:100%;object-fit:cover;">
                                </div>
                            <?php
                            }
                            ?>



                        </div>


                        <div id="desktopProfileOverlay" style="display:none; position:absolute; top:50px; right:0; background:white; box-shadow:0 4px 10px rgba(0,0,0,0.15); border-radius:8px; padding:10px 0; width:150px; z-index:1000;">
                            <a href="#" data-bs-toggle="modal" data-bs-target="#profileModal" style="display:block; padding:8px 15px; color:var(--black); text-decoration:none; font-weight:600;">View Profile</a>
                            <a onclick="signOut();" style="display:block; padding:8px 15px; color:var(--black); text-decoration:none; font-weight:600;">Sign out</a>
                        </div>
                    </div>
                    <!-- Large Screen -->

                </div>

            </div>
        </nav>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="Backend/Js/SignOut.js"></script>


    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const currentPage = window.location.pathname.split('/').pop().split('#')[0];
            const navLinks = document.querySelectorAll('.navbar-nav .nav-link');

            navLinks.forEach(link => {
                const linkPage = link.getAttribute('href').split('#')[0];
                if (linkPage === currentPage) {
                    link.classList.add('active');
                } else {
                    link.classList.remove('active');
                }
            });

            // 🧩 Keep Home active even after Bootstrap ScrollSpy updates
            const homeLink = document.querySelector('.navbar-nav .nav-link[href="index.php"]');
            if (homeLink) {
                document.addEventListener('activate.bs.scrollspy', () => {
                    homeLink.classList.add('active');
                });
            }
        });


        document.addEventListener('DOMContentLoaded', function() {
            const desktopProfileBtn = document.getElementById('desktopProfile');
            const desktopOverlay = document.getElementById('desktopProfileOverlay');

            desktopProfileBtn.addEventListener('click', function(e) {
                e.stopPropagation();
                desktopOverlay.style.display = (desktopOverlay.style.display === 'block') ? 'none' : 'block';
            });

            document.addEventListener('click', function() {
                desktopOverlay.style.display = 'none';
            });
        });
    </script>

    <!-- Profile Modal -->
    <div class="modal fade" id="profileModal" tabindex="-1" aria-labelledby="profileModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow-lg rounded-4 p-4" style="max-width:600px; margin:auto;">
                <div class="modal-header border-0">
                    <h4 class="modal-title w-100 text-center fw-bold" id="profileModalLabel" style="color:#f43f3f;">Student Profile</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center">
                    <!-- Profile Picture Upload -->
                    <div class="position-relative d-inline-block mb-3">
                        <img id="profileImagePreview" src="Resources/Images/Profile.jpg" class="rounded-4" style="width:160px; height:160px; object-fit:cover; cursor:pointer;" alt="Profile Picture">

                        <!-- Overlay background -->
                        <div id="profileOverlayText" class="position-absolute top-50 start-50 translate-middle text-white fw-bold d-flex flex-column align-items-center justify-content-center"
                            style="opacity:0; transition:opacity 0.3s ease; background:rgba(0,0,0,0.5); width:100%; height:100%; border-radius:8px;">
                            <button id="choosePicBtn" class="btn btn-sm fw-bold text-white" style="background:#f43f3f; border:none; border-radius:6px; padding:5px 12px;">Choose Picture</button>
                        </div>

                        <input type="file" id="profileImageInput" accept="image/*" style="display:none;">
                    </div>

                    <form class="text-center">
                        <div class="row g-3 justify-content-center mb-3">
                            <div class="col-md-6">
                                <input id="fname" type="text" class="form-control" placeholder="Akalanka">
                            </div>
                            <div class="col-md-6">
                                <input id="lname" type="text" class="form-control" placeholder="Perera">
                            </div>
                        </div>

                        <div class="mb-3">
                            <input id="email" type="email" class="form-control" placeholder="akalankapepera@gmail.com">
                        </div>

                        <div class="row g-3 justify-content-center mb-3">
                            <div class="col-md-6">
                                <input id="nic" type="text" class="form-control" placeholder="200306466433">
                            </div>
                            <div class="col-md-6">
                                <input id="mobile" type="text" class="form-control" placeholder="0784545432">
                            </div>
                        </div>

                        <div class="mt-3 position-relative mb-4 w-100" style=" margin:auto;">
                            <input id="password" type="password" class="form-control" placeholder="Akalanka123@34">
                            <i id="togglePassword" class="fa-solid fa-eye me-3" style="position:absolute; right:10px; top:50%; transform:translateY(-50%); cursor:pointer; color:#f43f3f;"></i>
                        </div>

                        <button type="button" class="btn save-btn w-100 py-2 fw-bold text-white" onclick="updateProfile()">
                            <i class="fa-solid fa-floppy-disk me-2"></i>Save Details
                        </button>

                    </form>
                </div>
            </div>
        </div>
    </div>
    <script>
     // Toggle password visibility
        document.addEventListener('DOMContentLoaded', () => {
            const togglePassword = document.getElementById('togglePassword');
        

            if (togglePassword && passwordInput) {
                togglePassword.addEventListener('click', () => {
                    const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                    passwordInput.setAttribute('type', type);
                    togglePassword.classList.toggle('fa-eye-slash');
                    togglePassword.classList.toggle('fa-eye');
                    
                });
            }
        });
    </script>
    <script src="Backend/Js/StudentProfile.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

</body>

</html>