<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sri Lanka’s First Digital Exam & Exam Practice Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://unpkg.com/aos@2.3.4/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="common.css">
    <link rel="icon" type="image/png" href="Resources/Logo/icon.png">

    <style>
        .left-section {
            background: url("Resources/Images/login-image.jpg");
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;

            position: relative;
            min-height: 100vh;
        }

        .left-text {
            margin-top: 310px;
        }

        .left-section::before {
            content: "";
            position: absolute;
            inset: 0;
            background: rgba(0, 0, 0, 0.5);
        }

        .left-section>div {
            position: relative;
            z-index: 2;
        }

        .left-section h1 {
            font-weight: 700;
            font-size: 40px;
        }

        @media (max-width: 1140px) {
            .left-section h1 {
                font-weight: 700;
                font-size: 30px;
            }

        }


        .left-section .highlight {
            color: var(--primary);
        }

        .right-section {
            background: #fff;
            border-left: 8px solid var(--primary);
            min-height: 100vh;
        }

        .contact-info {
            position: absolute;
            top: 15px;
            right: 30px;
            font-size: 0.9rem;
            color: var(--gray);
        }

        .registration-form h3 {
            font-weight: 700;
            color: var(--secondary);
        }

        .form-control {
            border-radius: 8px;
            padding: 10px 14px;
        }

        .toggle-password {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: var(--secondary);
        }

        .register-btn {

            height: 50px;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            border: none;
            border-radius: 8px;
            font-weight: 600;
            color: var(--light);

        }

        .register-btn:hover {
            color: var(--light);
            background: linear-gradient(135deg, var(--secondary), var(--primary));
            transition: background-color 0.3s, color 0.3s, transform 0.3s;
            transform: translateY(-3px);

        }

        .login-link {
            color: var(--primary);
            font-weight: 500;
            text-decoration: none;
        }

        .login-link:hover {
            text-decoration: underline;
        }

        @media (max-width: 991px) {
            .left-section {
                display: none;
            }

            .right-section {
                border: none;
            }
        }

        /* Mobile Optimization for Register Page */
        @media (max-width: 577px) {
            body {
                overflow-x: hidden;
            }

            .right-section {
                padding: 20px !important;
                min-height: auto !important;
            }

            .registration-form {
                width: 100% !important;
                margin: 0 auto !important;
                padding: 0 10px !important;
            }

            .registration-form h3 {
                font-size: 22px !important;
            }

            .registration-form p.text-muted {
                font-size: 13px !important;
            }

            .form-control {
                font-size: 14px !important;
                padding: 10px 12px !important;
            }

            .register-btn {
                font-size: 14px !important;
                padding: 10px 0 !important;
            }

            .toggle-password {
                right: 10px !important;
                top: 50% !important;
            }

            .contact-info {
            
                align-items: flex-start !important;
                font-size: 12px !important;
                top: 10px !important;
                right: 10px !important;
            }

            .left-section {
                display: none !important;
            }
        }
    </style>
</head>

<body style="overflow-x: hidden;">

    <div class="container-fluid min-vh-100">
        <div class="row h-100">

            <!-- Left Section -->
            <div class="col-lg-6 d-none d-lg-flex align-items-center justify-content-center left-section ">

                <div class="text-white text-center px-4 left-text" data-aos="fade-right">
                    <h1>Welcome to <span style="color: var(--secondary);"><img src="Resources/Logo/Logo.png" class="mb-2" style="height: 50px;"></span></h1>
                    <p class="text-start">Transforms lives through education</p>
                </div>
            </div>

            <!-- Right Section -->
            <div class="col-lg-6 d-flex flex-column justify-content-center px-5 py-4 right-section">

                <!-- Top Contact Info -->
                <div class="d-flex justify-content-end contact-info">
                    <span class="me-3"><img src="Resources/Icons/email.png" style="height: 18px;">
                        <a href="https://mail.google.com/mail/?view=cm&fs=1&to=team.eexam@gmail.com"
                            target="_blank"
                            style="text-decoration:none; color:inherit;">
                            team.eexam@gmail.com
                        </a>
                    </span>

                    <span><img src="Resources/Icons/hotline.png" style="height: 18px;"> 
                       <a href="https://wa.me/94753595844" 
           target="_blank" 
           style="text-decoration:none; color:inherit;">
            075 359 5844
        </a>
                </span>


                </div>

                <!-- Registration Form -->
                <div class="registration-form mt-5 ">


                    <div>
                        <div class="row col-md-10 col-12 col-lg-12 col-xl-10  g-3 mx-auto mt-5 " data-aos="fade-up">

                            <div class="container   ">
                                <h3 class="mb-2">Student Registration</h3>
                                <p class="text-muted mb-4">Enter your credentials to continue</p>
                            </div>

                            <div class="col-md-6 ">
                                <label for="form-label" class="mb-1 fw-bold">First Name</label>
                                <input id="fname" type="text" class="form-control" placeholder="John">
                            </div>
                            <div class="col-md-6">
                                <label for="form-label" class="mb-1 fw-bold">Last Name</label>
                                <input id="lname" type="text" class="form-control" placeholder="Smith">
                            </div>

                            <div class="mt-3">
                                <label for="form-label" class="mb-1 fw-bold">Email Address</label>
                                <input id="email" type="email" class="form-control" placeholder="johnsmith@example.com">
                            </div>

                            <div class="col-md-6">
                                <label for="form-label" class="mb-1 fw-bold">NIC</label>
                                <input id="nic" type="text" class="form-control" placeholder="2000********">
                            </div>
                            <div class="col-md-6">
                                <label for="form-label" class="mb-1 fw-bold">Mobile</label>
                                <input id="mobile" type="text" class="form-control" placeholder="077xxxxxxx">
                            </div>

                            <div class="mt-3 position-relative">
                                <label for="form-label" class="mb-1 fw-bold">Passwoord</label>
                                <input id="password" type="password" class="form-control" id="password" placeholder="Em!lyJ#2024">
                                <i class="fa-solid fa-eye toggle-password me-3 mt-3" id="togglePassword"></i>
                            </div>

                            <div class=" d-grid">
                                <button onclick="SignUp();" class="btn register-btn mt-4 ">
                                    <img class="me-2" src="Resources/Icons/login.png" style="height: 30px;">Register to Dashboard
                                </button>
                            </div>

                            <p class="mt-3 text-start">
                                Already our member? <a href="login.php" class="login-link">Login here</a>
                            </p>

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="common.js"></script>
    <script src="Backend/Js/SignUp.js"></script>
    <!-- AOS Animation Script -->
    <script src="https://unpkg.com/aos@2.3.4/dist/aos.js"></script>
    <script>
        AOS.init({
            duration: 800,
            once: true,
            offset: 80,
        });
    </script>
</body>

</html>