<?php
session_start();
include "Backend/Process/connection.php";

if (isset($_SESSION["admin"])) {
?>

    <!DOCTYPE html>
    <html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Sri Lanka’s First Digital Exam & Exam Practice Platform</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
        <link rel="stylesheet" href="common.css">
        <link rel="icon" type="image/png" href="Resources/Logo/icon.png">
        <style>
            /* Slightly reduce width of Category Registration select button on large screens */
            @media (min-width: 992px) {
                #addSubjectsPanel .form-select[style*="flex:0.1"] {
                    flex: 0.06 !important;
                }
            }

            /* Select Quize Details - Mobile optimization for Clear button */
            @media (max-width: 577px) {
                #addQuizPanel .d-flex.flex-wrap.gap-3 > button.btn.btn-danger.ms-auto {
                    width: 100% !important;
                    margin-top: 8px !important;
                }
            }

            /* Quiz Registration - Mobile optimization for Add and Clear buttons */
            @media (max-width: 577px) {
                #addQuizPanel .d-flex.justify-content-center.align-items-center.gap-3.flex-wrap.mb-4 {
                    flex-direction: column !important;
                    align-items: stretch !important;
                }

                #addQuizPanel #addBtn,
                #addQuizPanel #updateBtn,
                #addQuizPanel .btn.ms-auto {
                    width: 100% !important;
                    font-size: 14px !important;
                    padding: 8px 0 !important;
                }

                /* Clear button in Quiz Registration - match Add button styling and width on mobile */
                #addQuizPanel .d-flex.justify-content-center.align-items-center.gap-3.flex-wrap.mb-4 button.btn-danger:last-of-type {
                    width: 100% !important;
                    font-size: 14px !important;
                    padding: 8px 0 !important;
                }
            }

            /* --- Admin Panel Tabs --- */
            .admin-tabs {
                position: sticky;
                top: 70px;
                /* Adjust if navbar is fixed */
                z-index: 1000;
                /* Keep above other elements */
                background: var(--light);
                border-radius: 12px;
                padding: 15px 30px;
                display: flex;
                justify-content: center;
                align-items: center;
                flex-wrap: wrap;
                /* Allow wrapping instead of scrolling */
                gap: 60px;
                /* Adjust spacing between tabs */
                box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15);
                width: 100%;
                margin: 0 auto;
                /* Center correctly */
                overflow-x: hidden;
                /* Prevent horizontal scrolling */
            }

            .admin-tab {
                border: none;
                background: transparent;
                font-weight: 600;
                color: var(--black);
                font-size: 17px;
                transition: all 0.3s ease;
                padding: 10px 25px;
                border-radius: 8px;
            }

            .admin-tab.active {
                background: var(--primary);
                color: var(--light);
                box-shadow: 0 4px 10px rgba(217, 38, 38, 0.3);
            }

            .admin-tab:hover:not(.active) {
                color: var(--secondary);
            }

            .search-box {
                position: relative;
                width: 200px;
                border: 2px solid var(--primary);
                border-radius: 50px;
                background: transparent;
                padding: 0;
                display: flex;
                align-items: center;
            }

            .search-box input {
                width: 100%;
                border: none;
                outline: none;
                padding: 8px 40px 8px 15px;
                font-size: 14px;
                border-radius: 50px;
                background: transparent;
            }

            .search-btn {
                position: absolute;
                right: 6px;
                border: none;
                background: transparent;
                padding: 0;
                display: flex;
                align-items: center;
            }

            .search-btn img {
                height: 24px;
                width: auto;
                object-fit: contain;
            }

            /* Mobile size */
            @media (max-width: 768px) {
                .search-box {
                    width: 180px;
                }
                .search-box input {
                    padding: 7px 38px 7px 12px;
                }
                .search-btn img {
                    height: 22px;
                    width: auto;
                    object-fit: contain;
                }
            }

            /* --- Responsive Design for Admin Tabs --- */
            @media (max-width: 992px) {
                .admin-tabs {
                    flex-wrap: wrap;
                    gap: 25px;
                    padding: 15px 25px;
                    overflow-x: hidden;
                    /* Ensure no scroll on smaller screens */
                }
            }


            .stat-card {
                transition: all 0.3s ease;
                display: flex;
                flex-direction: column;
                justify-content: space-between;
                align-items: flex-start;
                height: 180px;
                padding: 25px 30px;
                position: relative;
            }

            .stat-card:hover {
                transform: translateY(-3px);
            }

            .stat-card .stat-value {
                font-size: 3rem; /* base font size */
                font-weight: 700;
                background: linear-gradient(135deg, var(--primary), var(--secondary));
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                display: inline-block;
                margin-bottom: 5px;
            }

            .stat-card i {
                font-size: 3rem;
                background: linear-gradient(135deg, var(--primary), var(--secondary));
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                display: inline-block;
                position: absolute;
                top: 20px;
                right: 25px;
                opacity: 0.9;
            }

            .stat-card .fw-semibold {
                font-size: 17px;
                color: var(--black);
                font-weight: 600;
                margin-top: auto;
            }

            /* Mobile responsive for Dashboard Stat Cards */
            @media (max-width: 577px) {
                .stat-card {
                    height: 150px;
                    padding: 18px 20px;
                }
                .stat-card .stat-value {
                    font-size: 3.2rem; /* larger on mobile */
                }
                .stat-card i {
                    font-size: 2.2rem;
                    top: 15px;
                    right: 18px;
                }
                .stat-card .fw-semibold {
                    font-size: 14px;
                }
            }

            @media (max-width: 577px) {
                #student_table_body td,
                #student_table_body th {
                    font-size: 13px !important;
                    padding: 6px !important;
                }

                .table-responsive {
                    max-height: 300px;
                }
            }

            @media (max-width: 577px) {
                table thead th {
                    font-size: 12px !important;
                    padding: 6px !important;
                    white-space: nowrap !important;
                }
            }

            /* Fix Registered_Date text breaking on all screen sizes */
            table tbody td:nth-child(7) {
                white-space: nowrap !important;
            }

            /* Reduce Status button size on mobile */
            @media (max-width: 577px) {
                .status-activated,
                .status-deactivated {
                    width: 90px !important;
                    padding: 6px 0 !important;
                    font-size: 12px !important;
                    border-radius: 6px !important;
                }
            }

            /* Equal card sizing and spacing */
            #adminDashboardPanel .row {
                justify-content: space-between !important;
            }

            #adminDashboardPanel .col-lg-4 {
                display: flex;
                justify-content: center;
            }

            #adminDashboardPanel .stat-card {
                width: 100%;
                max-width: 100%;
            }

            .success-btn,
            .accept-btn {
                padding: 7px 10px;
                background-color: var(--success);
                color: var(--light);
                border: none;
                border-radius: 4px;
                transition: all 0.3s ease;
            }

            .success-btn:hover {
                background-color: #00997a;
               
            }

            .table-responsive {
                max-height: 400px;
                overflow-y: auto;
                overflow-x: auto;
                display: block;
            }

            .table thead th {
                position: sticky;
                top: 0;
                background: #fff;
                z-index: 2;
            }

            /* --- Standardized Status Buttons --- */
            .table .badge {
                display: inline-block;
                min-width: 100px;
                text-align: center;
                padding: 10px 0;
                font-size: 14px;
                font-weight: 600;
                border-radius: 8px;
            }

            /* --- Custom Status Buttons --- */
            .status-activated,
            .status-deactivated {
                display: inline-block;
                width: 120px;
                text-align: center;
                padding: 8px 0;
                border-radius: 8px;
                font-weight: 600;
                font-size: 14px;
                color: #fff !important;
                cursor: pointer;
            }

            .status-activated {
                background-color: var(--success) !important;
                /* Green */
            }

            .status-deactivated {
                background-color: var(--primary) !important;
                /* Red */
            }

            .status-activated:hover {
                background-color: #039a79ff !important;
                /* Darker green on hover */
                transform: scale(1.05);
                transition: all 0.3s ease;
            }

            .status-deactivated:hover {
                background-color: #b52a2a !important;
                /* Darker red on hover */
                transform: scale(1.05);
                transition: all 0.3s ease;
            }

            /* Extra Large Stat Value on very small screens */
            @media (max-width: 576px) {
                .stat-card .stat-value {
                    font-size: 2.0rem !important; /* increase font size for very small screens */
                }
            }

            /* Course Registration - Mobile layout adjustments */
            @media (max-width: 577px) {
                #addSubjectsPanel .bg-white h5.fw-bold.mb-0 {
                    display: block;
                    width: 100%;
                    margin-bottom: 10px;
                }

                #addSubjectsPanel .bg-white .d-flex.justify-content-end.align-items-center {
                    width: 100%;
                    justify-content: flex-start;
                    margin-top: 5px;
                }

                #addSubjectsPanel .bg-white .search-box {
                    margin-left: 0;
                }
            }

            /* Quiz Registration - Mobile Optimization */
            @media (max-width: 577px) {
                #addQuizPanel {
                    padding: 10px !important;
                }

                #addQuizPanel h5.fw-bold {
                    font-size: 1rem !important;
                    width: 100%;
                    text-align: center;
                    margin-bottom: 8px;
                }

                #addQuizPanel .d-flex.flex-wrap.gap-3,
                #addQuizPanel .d-flex.align-items-center.gap-1,
                #addQuizPanel .d-flex.flex-column.gap-3.mb-4,
                #addQuizPanel .d-flex.justify-content-center.align-items-center.gap-3.flex-wrap.mb-4 {
                    flex-direction: column !important;
                    width: 100% !important;
                    gap: 8px !important;
                }

                #addQuizPanel select,
                #addQuizPanel input,
                #addQuizPanel textarea,
                #addQuizPanel button,
                #addQuizPanel .search-box {
                    width: 100% !important;
                    font-size: 14px !important;
                }

                #addQuizPanel #quizCountBadge {
                    flex: 0 0 auto;
                    width: 50px;
                    height: 38px;
                    margin: 0 auto !important; /* centers the button horizontally */
                }

                #addQuizPanel .btn {
                    width: 100% !important;
                }

                #addQuizPanel .d-flex.align-items-center.gap-3 > button {
                    width: 45px !important;
                }
            }

            /* Access Panel - Header alignment for desktop */
            @media (min-width: 578px) {
                #addAccessPanel .subject-access-header {
                    display: flex !important;
                    justify-content: space-between !important;
                    align-items: center !important;
                }

                #addAccessPanel .subject-access-header h5 {
                    margin-bottom: 0 !important;
                }
            }

            /* Subject Access Table - Mobile optimization for Action buttons */
            @media (max-width: 567px) {
                #addAccessPanel table tbody td:last-child {
                    display: flex !important;
                    flex-direction: row !important;
                    justify-content: flex-start;
                    gap: 5px;
                }

                #addAccessPanel table tbody td:last-child button {
                    width: 100% !important; /* increased from 48% to 52% */
                    font-size: 12px !important;
                    padding: 5px 15px !important;
                }
            }


            @media (min-width: 567px) {
                #addAccessPanel table tbody td:last-child {
                    display: flex !important;
                    flex-direction: row !important;
                    justify-content: flex-start;
                    gap: 5px;
                }

                #addAccessPanel table tbody td:last-child button {
                    width: 100% !important; /* increased from 48% to 52% */
                    font-size: 13px !important;
                    padding: 6px 15px !important;
                }
            }

            /* Lesson Registration - Mobile Optimization */
            @media (max-width: 577px) {
                #addSubjectsPanel #lLesson,
                #addSubjectsPanel #lAddBtn,
                #addSubjectsPanel #lUpdateBtn,
                #addSubjectsPanel button[onclick="lessonClear();"] {
                    width: 100% !important;
                }

                #addSubjectsPanel .d-flex.gap-1 {
                    flex-direction: column !important;
                    gap: 10px !important;
                }
            }

            /* Category Registration - Mobile layout adjustments */
            @media (max-width: 577px) {
                #addSubjectsPanel #scategory,
                #addSubjectsPanel #cat_status {
                    width: 100% !important;
                    min-width: 100% !important;
                    flex: unset !important;
                }

                #addSubjectsPanel .d-flex.mb-4.gap-2.flex-wrap {
                    flex-direction: column !important;
                    gap: 10px !important;
                }
            }

            /* Category Registration - Make Add, Update, Clear buttons full width on mobile */
            @media (max-width: 577px) {
                #addSubjectsPanel .d-flex.justify-content-end.mt-4.gap-2 button {
                    width: 100% !important;
                }

                #addSubjectsPanel .d-flex.justify-content-end.mt-4.gap-2 {
                    flex-direction: column !important;
                    gap: 10px !important;
                }
            }
        </style>

    </head>

    <body onload="loadStudents(); loadCategories(); loadCourse(); loadSubject(); loadLesson(); loadRequests();">

        <!-- Navbar -->
        <?php include "AdminNav.php" ?>
        <!-- Navbar include removed -->

        <div class="container my-4 " style="padding-top: 60px;">
            <div class="admin-tabs d-none d-lg-block">
                <button class="admin-tab active" data-target="dashboard">Admin Dashboard</button>
                <button class="admin-tab" data-target="subjects">Add Subjects</button>
                <button class="admin-tab" data-target="quiz">Add Quiz</button>
                <button class="admin-tab" data-target="access">Access</button>
            </div>



            <!-- Admin Dashboard Panel -->
            <div id="adminDashboardPanel" class="container mt-4">
                <div class="row g-4 justify-content-center">

                    <?php
                    $students = Database::search("SELECT COUNT(*) AS total FROM `student`");
                    $row = $students->fetch_assoc();
                    $count = intval($row['total']);

                    ?>

                    <div class="col-lg-4 col-md-4 col-sm-12">
                        <div class="stat-card text-center p-4 bg-white rounded-4 shadow-sm h-100">
                            <div class="stat-value fs-1 fw-bold text-danger" id="admin-students-count"><?php echo $count ?></div>
                            <i class="fa-solid fa-user-graduate fa-3x my-2 text-danger"></i>
                            <div class="fw-semibold">Registered Students</div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-4 col-sm-12">
                        <div class="stat-card text-center p-4 bg-white rounded-4 shadow-sm h-100">
                            <div class="stat-value fs-1 fw-bold text-danger" id="admin-courses-count">0</div>
                            <i class="fa-solid fa-user-check fa-3x my-2 text-danger"></i>
                            <div class="fw-semibold">Registered Course</div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-4 col-sm-12">
                        <div class="stat-card text-center p-4 bg-white rounded-4 shadow-sm h-100">
                            <div class="stat-value fs-1 fw-bold text-danger" id="admin-subjects-count">0</div>
                            <i class="fa-solid fa-book fa-3x my-2 text-danger"></i>
                            <div class="fw-semibold">Registered Subject</div>
                        </div>
                    </div>

                </div>

                <!-- Search bar -->
                <div class="d-flex justify-content-end align-items-center mt-4">

                    <div class="search-box">
                        <input onkeyup="loadStudents();" id="search" type="text" placeholder="Search students...">
                        <button class="search-btn" onclick="loadStudents();" type="button">
                            <img src="Resources/Icons/find.png" style="height:28px; ">
                        </button>
                    </div>
                    
                </div>

                <!-- Registered Students Table -->
                <div class="bg-white rounded-4 shadow-sm mt-4 p-4">
                    <h5 class="fw-bold mb-3">Registered Students</h5>
                    <div class="table-responsive" style="max-height:400px; overflow-y:auto; overflow-x:auto; display:block;">
                        <table class="table align-middle table-hover">

                            <thead class="table-light">
                                <tr>
                                    <th>First Name</th>
                                    <th>Last Name</th>
                                    <th>NIC</th>
                                    <th>Mobile</th>
                                    <th>Email</th>
                                    <th>Password</th>
                                    <th>Registerd_Date</th>
                                    <th>Status</th>
                                </tr>
                            </thead>

                            <tbody id="student_table_body">


                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Add Subjects Panel -->
        <div id="addSubjectsPanel" class="container mt-4 mb-5" style="display:none;">

            <!-- Category Registration -->
            <div class="bg-white rounded-4 shadow-sm p-4 mt-5 mb-5" style="border:2px dashed #d92626;">
                <h5 class="fw-bold mb-3">Category Registration</h5>

                <div class="row mb-3 align-items-end">
                    <div class="col-12">

                        <div class="d-flex mb-4 gap-2 flex-wrap">
                            <select id="scategory" class="form-select" style="flex:1.7; min-width:220px;">
                                <option value="0" selected>Select Category...</option>
                                <?php
                                $rs = Database::search("SELECT * FROM `category`");
                                $num = $rs->num_rows;

                                for ($x = 0; $x < $num; $x++) {
                                    $data = $rs->fetch_assoc();
                                ?>
                                    <option value="<?php echo $data["id"]; ?>">
                                        <?php echo $data["title"]; ?>
                                    </option>
                                <?php
                                }
                                ?>
                            </select>
                            <select id="cat_status" class="form-select" style="flex:0.1; min-width:125px;">
                                <option value="0">Select</option>
                                <?php
                                $rs = Database::search("SELECT * FROM `category_status`");
                                $num = $rs->num_rows;

                                for ($x = 0; $x < $num; $x++) {
                                    $data = $rs->fetch_assoc();
                                ?>
                                    <option value="<?php echo $data["id"]; ?>">
                                        <?php echo $data["value"]; ?>
                                    </option>
                                <?php
                                }
                                ?>
                            </select>
                        </div>


                        <div class="d-flex align-items-center gap-3">
                            <input id="title" type="text" class="form-control fw-semibold" placeholder="Add Category">
                            <!-- <input type="text" class="form-control fw-semibold" placeholder="Enter Price..." style="flex: 0.7;"> -->
                        </div>

                        <div class="row mt-4">
                            <div class="col-md-6">
                                <label class="fw-semibold mb-2">Upload Image</label>
                                <div id="categoryImageBox" class="mb-2 border rounded-3 d-flex justify-content-center align-items-center position-relative"
                                    style="height:230px; cursor:pointer;"
                                    onmouseenter="showUploadBtn(this)"
                                    onmouseleave="hideUploadBtn(this)"
                                    onclick="triggerFileInput(this)">
                                    <button class="btn btn-danger px-4 position-absolute d-none upload-btn fw-semibold">Upload</button>
                                    <input id="image" type="file" accept="image/*" class="d-none file-input">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="fw-semibold mb-2">Description</label>
                                <textarea id="description" class="form-control" rows="9" placeholder="Enter description..."></textarea>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="d-flex justify-content-end mt-4 gap-2">
                    <button onclick="addCategory();" id="cAddBtn" class="btn btn-danger px-4 fw-semibold">Add</button>
                    <button onclick="addCategory();" id="cUpdateBtn" class=" success-btn px-3 d-none fw-semibold">Update</button>
                    <button onclick="clearCategoryFields();" class="btn btn-danger px-4 fw-semibold">Clear</button>

                </div>
            </div>

            <!-- Course Registration Section -->
            <div class="bg-white rounded-4 shadow-sm p-4 mb-5" style="border:2px dashed #d92626;">

                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h5 class="fw-bold mb-0">Course Registration</h5>
                    <!-- Search bar -->
                    <div class="d-flex justify-content-end align-items-center">
                        <div class="search-box">
                            <input onkeyup="loadCourse();" id="courseText" type="text" placeholder="Search courses...">
                            <button class="search-btn" onclick="loadCourse();" type="button">
                                <img src="Resources/Icons/find.png" style="height:28px;">
                            </button>
                        </div>
                    </div>
                </div>
                <!-- Category dropdown inserted here -->

                <select id="cCategory" class="form-select mb-3">
                    <option value="0">Select Category...</option>
                    <?php
                    $rs = Database::search("SELECT * FROM `category` WHERE `category_status_id` = '1'");
                    $num = $rs->num_rows;

                    for ($x = 0; $x < $num; $x++) {
                        $data = $rs->fetch_assoc();
                    ?>
                        <option value="<?php echo $data["id"]; ?>">
                            <?php echo $data["title"]; ?>
                        </option>
                    <?php
                    }
                    ?>
                </select>
                <div class="d-flex mb-4 gap-1">
                    <input id="cCourse" type="text" class="form-control" placeholder="Add Course..." />
                    <button id="courseAddBtn" onclick="addCourse();" class="btn btn-danger px-3 d-block fw-semibold">Add</button>
                    <button id="courseUpdateBtn" onclick="updateCourse();" class="success-btn px-3 fw-semibold d-none">Update</button>
                    <button onclick="CourseClear();" class="btn btn-danger px-3 d-block fw-semibold">Clear</button>
                </div>

                <h6 class="fw-bold mb-3">Added Courses</h6>
                <div id="coursView" class="d-flex flex-column gap-3" style="max-height:300px; overflow-y:auto; border:1px solid #ddd; padding:10px; border-radius:8px;">


                </div>
            </div>

            <!-- Subject Registration Section -->
            <div class="bg-white rounded-4 shadow-sm p-4" style="border:2px dashed #d92626;">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h5 class="fw-bold mb-0">Subject Registration</h5>
                    <!-- Search bar -->
                    <div class="d-flex justify-content-end align-items-center">
                        <div class="search-box">
                            <input onkeyup="loadSubject();" id="subjectText" type="text" placeholder="Search subjects...">
                            <button class="search-btn" onclick="loadSubject();" type="button">
                                <img src="Resources/Icons/find.png" style="height:28px;">
                            </button>
                        </div>
                    </div>
                </div>
                <div class="mb-3">
                    <select id="sCourse" class="form-select mb-3">
                        <option value="0" selected>Select Course...</option>
                        <?php
                        $rs = Database::search("SELECT * FROM `course`");
                        $num = $rs->num_rows;

                        for ($x = 0; $x < $num; $x++) {
                            $data = $rs->fetch_assoc();
                        ?>
                            <option value="<?php echo $data["id"]; ?>">
                                <?php echo $data["title"]; ?>
                            </option>
                        <?php
                        }
                        ?>
                    </select>
                    <div class="d-flex gap-1">
                        <input id="sSubject" type="text" class="form-control" placeholder="Add Subject..." style="flex: 0.7;">
                        <input id="sPrice" type="text" class="form-control" placeholder="Enter Price..." style="flex: 0.3;">
                        <button onclick="addSubject();" id="sAddBtn" class="btn btn-danger px-3 d-block fw-semibold">Add</button>
                        <button onclick="updateSubject();" id="sUpdateBtn" class=" success-btn fw-semibold px-3 d-none">Update</button>
                        <button onclick="subjectClear();" class="btn btn-danger px-3 d-block fw-semibold">Clear</button>
                    </div>
                </div>

                <h6 class="fw-bold mb-3">Added Subjects</h6>
                <div id="subjectView" class="d-flex flex-column gap-3" style="max-height:300px; overflow-y:auto; border:1px solid #ddd; padding:10px; border-radius:8px;">


                </div>
            </div>

            <!-- Lesson Registration Section -->
            <div class="bg-white rounded-4 shadow-sm p-4 mt-5" style="border:2px dashed #d92626;">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h5 class="fw-bold mb-0">Lesson Registration</h5>
                    <!-- Search bar -->
                    <div class="d-flex justify-content-end align-items-center">
                        <div class="search-box">
                            <input onkeyup="loadLesson();" id="lessonText" type="text" placeholder="Search lessons...">
                            <button class="search-btn" onclick="loadLesson();" type="button">
                                <img src="Resources/Icons/find.png" style="height:28px;">
                            </button>
                        </div>
                    </div>
                </div>

                <div class="mb-3">

                    <select id="lSubject" class="form-select mb-3">
                        <option value="0" selected>Select Subject...</option>
                        <?php
                        $rs = Database::search("SELECT * FROM `subject`");
                        $num = $rs->num_rows;

                        for ($x = 0; $x < $num; $x++) {
                            $data = $rs->fetch_assoc();
                        ?>
                            <option value="<?php echo $data["id"]; ?>">
                                <?php echo $data["title"]; ?>
                            </option>
                        <?php
                        }
                        ?>
                    </select>

                    <div class="d-flex gap-1">
                        <input id="lLesson" type="text" class="form-control" placeholder="Add Lesson..." />
                        <button id="lAddBtn" onclick="addLesson();" class="btn btn-danger fw-semibold px-3">Add</button>
                        <button onclick="updateLesson();" id="lUpdateBtn" class=" success-btn px-3 fw-semibold d-none">Update</button>
                        <button onclick="lessonClear();" class="btn btn-danger fw-semibold px-3">Clear</button>
                    </div>
                </div>

                <h6 class="fw-bold mb-3">Added Lessons</h6>
                <div id="lessonView" class="d-flex flex-column gap-3" style="max-height:300px; overflow-y:auto; border:1px solid #ddd; padding:10px; border-radius:8px;">


                </div>

            </div>


        </div>





        <!-- Add Quiz Panel -->
        <div id="addQuizPanel" class="container mt-4" style="display:none;">
            <div class="bg-white rounded-4 shadow-sm p-4 mb-5" style="border:2px dashed #d92626;">
                <h5 class="fw-bold mb-3">Select Quize Details</h5>

                <div class="d-flex flex-wrap gap-3">

                    <select id="category" class="form-select flex-fill" style="min-width:250px;">
                        <option selected>Select Category...</option>

                    </select>

                    <select id="course" class="form-select flex-fill" style="min-width:250px;">
                        <option selected>Select Course...</option>

                    </select>

                    <select id="subject" class="form-select flex-fill" style="min-width:250px;">
                        <option selected>Select Subject...</option>

                    </select>

                    <select id="lesson" class="form-select flex-fill" style="min-width:250px;">
                        <option value="0" selected>Select Lesson...</option>

                    </select>
                    <button onclick="clearQuizFields();" class="btn btn-danger ms-auto fw-semibold">Clear</button>
                </div>

            </div>

            <div class="bg-white rounded-4 shadow-sm p-4 mb-5" style="border:2px dashed #d92626;">
                <h5 class="fw-bold mb-3">Quiz Registration</h5>

                <div class=" d-flex align-items-center gap-1 mb-4">
                    <select id="medium1" class="form-select w-auto">
                        <option value="0" selected>Select Medium</option>
                        <?php
                        $rs = Database::search("SELECT * FROM `medium`");
                        $num = $rs->num_rows;

                        for ($x = 0; $x < $num; $x++) {
                            $data = $rs->fetch_assoc();
                        ?>

                            <option value="<?php echo $data["id"]; ?>">
                                <?php echo $data["name"]; ?>
                            </option>

                        <?php
                        }

                        ?>
                    </select>
                    <select id="quiz_number" class="form-select w-auto">
                        <option value="0" selected>Select Quiz</option>

                    </select>
                    <button onclick="deleteQuiz();" class="btn btn-danger fw-semibold">Delete</button>
                    <div id="quizCountBadge" class="ms-auto bg-danger text-white btn btn-danger d-flex align-items-center justify-content-center fw-semibold" style="min-width: 50px; height: 38px;">0</div>
                </div>

                <div class="mb-3">
                    <textarea id="question" class="form-control fw-semibold" rows="3" placeholder="Enter question here..."></textarea>
                </div>

                <div class="d-flex flex-column gap-3 mb-4">
                    <div class="d-flex align-items-center gap-3">
                        <button class="btn btn-danger fw-bold" style="width:45px;">A</button>
                        <input id="option_A" type="text" class="form-control" placeholder="Enter option A..." />
                    </div>
                    <div class="d-flex align-items-center gap-3">
                        <button class="btn btn-danger fw-bold" style="width:45px;">B</button>
                        <input id="option_B" type="text" class="form-control" placeholder="Enter option B..." />
                    </div>
                    <div class="d-flex align-items-center gap-3">
                        <button class="btn btn-danger fw-bold" style="width:45px;">C</button>
                        <input id="option_C" type="text" class="form-control" placeholder="Enter option C..." />
                    </div>
                    <div class="d-flex align-items-center gap-3">
                        <button class="btn btn-danger fw-bold" style="width:45px;">D</button>
                        <input id="option_D" type="text" class="form-control" placeholder="Enter option D..." />
                    </div>
                </div>

                <div class="d-flex justify-content-center align-items-center gap-1 flex-wrap mb-4">

                    <select id="medium" class="form-select w-auto">
                        <option value="0" selected>Medium</option>

                        <?php
                        $rs = Database::search("SELECT * FROM `medium`");
                        $num = $rs->num_rows;

                        for ($x = 0; $x < $num; $x++) {
                            $data = $rs->fetch_assoc();
                        ?>

                            <option value="<?php echo $data["id"]; ?>">
                                <?php echo $data["name"]; ?>
                            </option>

                        <?php
                        }

                        ?>

                    </select>

                    <select id="answer" class="form-select w-auto">
                        <option value="0" selected>Answer</option>
                        <option value="A">A</option>
                        <option value="B">B</option>
                        <option value="C">C</option>
                        <option value="D">D</option>
                    </select>

                    <button id="addBtn" onclick="add();" class="btn btn-danger px-3 fw-semibold">Add</button>
                    <button id="updateBtn" onclick="add();" class=" success-btn px-3 fw-semibold d-none">Update</button>
                    <button onclick="clearFields();" class="btn btn-danger px-3 fw-semibold">Clear</button>

                </div>
            </div>
        </div>


        <!-- Access Panel -->
        <div id="addAccessPanel" class="container mt-4" style="display:none;">
            <div class="subject-access-section bg-white rounded-4 shadow-sm p-4 mt-5 mb-5" style="border:2px dashed #d92626;height:600px;">
                <div class="subject-access-header d-flex justify-content-between align-items-center mb-3">
                    <h5 class="fw-bold">Subject Access</h5>
                    <!-- Search bar -->
                    <div class="d-flex justify-content-end align-items-center ">
                        <div class="search-box">
                            <input type="text" placeholder="Search requests..." id="accessSearch" onkeyup="loadRequests();">
                            <button class="search-btn" onclick="loadRequests();">
                                <img src="Resources/Icons/find.png" style="height:28px; ">
                            </button>
                        </div>
                    </div>

                </div>
                <div class="table-responsive">
                    <table class="table align-middle table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>First Name</th>
                                <th>NIC</th>
                                <th>Mobile</th>
                                <th>Email</th>
                                <th>Subject</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="tbody">
                            
                        </tbody>
                    </table>
                </div>
                <div class="no-content text-center py-5" style="display:none;">
                    <h1 class="fw-bold text-secondary opacity-50">No Requests</h1>
                </div>
            </div>
        </div>



        <script src="Backend/Js/LoadStudents.js"></script>
        <script src="Backend/Js/Quiz.js"></script>
        <script src="Backend/Js/Category.js"></script>
        <script src="Backend/Js/Course.js"></script>
        <script src="Backend/Js/Subject.js"></script>
        <script src="Backend/Js/Lesson.js"></script>
        <script src="Backend/Js/LoadRequest.js"></script>
        <script>
            const adminTabs = document.querySelectorAll('.admin-tab');
            const adminDashboardPanel = document.getElementById('adminDashboardPanel');
            const addSubjectsPanel = document.getElementById('addSubjectsPanel');
            const addQuizPanel = document.getElementById('addQuizPanel');
            const accessPanel = document.getElementById('addAccessPanel'); // Access section

            // Function to switch tabs
            function switchTab(targetTab) {
                // Remove active class from all tabs
                adminTabs.forEach(btn => btn.classList.remove('active'));
                
                // Hide all panels
                adminDashboardPanel.style.display = 'none';
                addSubjectsPanel.style.display = 'none';
                addQuizPanel.style.display = 'none';
                if (accessPanel) accessPanel.style.display = 'none';

                // Show selected tab and panel
                const selectedTab = Array.from(adminTabs).find(tab => tab.dataset.target === targetTab);
                if (selectedTab) {
                    selectedTab.classList.add('active');
                    
                    if (targetTab === 'dashboard') {
                        adminDashboardPanel.style.display = 'block';
                    } else if (targetTab === 'subjects') {
                        addSubjectsPanel.style.display = 'block';
                    } else if (targetTab === 'quiz') {
                        addQuizPanel.style.display = 'block';
                    } else if (targetTab === 'access') {
                        if (accessPanel) {
                            accessPanel.style.display = 'block';
                            // Load subject requests when Access panel is opened
                            if (typeof loadRequests === 'function') {
                                loadRequests();
                            }
                        }
                    }
                    
                    // Save selected tab to localStorage
                    localStorage.setItem('adminSelectedTab', targetTab);
                }
            }

            // Add click listeners to tabs
            adminTabs.forEach(tab => {
                tab.addEventListener('click', () => {
                    switchTab(tab.dataset.target);
                });
            });

            // Restore selected tab from localStorage on page load
            const savedTab = localStorage.getItem('adminSelectedTab');
            if (savedTab && ['dashboard', 'subjects', 'quiz', 'access'].includes(savedTab)) {
                switchTab(savedTab);
            } else {
                // Default to dashboard
                switchTab('dashboard');
            }

            // Load admin stats dynamically
            async function loadAdminStats() {
                try {
                    const response = await fetch("Backend/Process/LoadCounts.php");
                    const json = await response.json();
                    
                    if (json.status && json.data) {
                        // Update students count
                        const studentsCount = document.getElementById("admin-students-count");
                        if (studentsCount) {
                            studentsCount.textContent = json.data.students || 0;
                        }
                        
                        // Update courses count
                        const coursesCount = document.getElementById("admin-courses-count");
                        if (coursesCount) {
                            coursesCount.textContent = json.data.courses || 0;
                        }
                        
                        // Update subjects count
                        const subjectsCount = document.getElementById("admin-subjects-count");
                        if (subjectsCount) {
                            subjectsCount.textContent = json.data.subjects || 0;
                        }
                    }
                } catch (err) {
                    console.error("Error loading admin stats:", err);
                }
            }

            // Load stats on page load
            loadAdminStats();

            // --- Stat Value Counter Animation ---
            document.addEventListener("DOMContentLoaded", () => {
                // Wait for stats to load before animating
                setTimeout(() => {
                    const counters = document.querySelectorAll('.stat-value');
                    const speed = 100; // lower = faster

                    counters.forEach(counter => {
                        const target = +counter.textContent.replace(/\D/g, ''); // remove non-numeric
                        if (target > 0) {
                            const initialValue = target;
                            counter.textContent = '0';
                            const updateCount = () => {
                                const current = +counter.textContent.replace(/\D/g, '');
                                const increment = Math.ceil(target / speed);

                                if (current < target) {
                                    counter.textContent = current + increment;
                                    setTimeout(updateCount, 20);
                                } else {
                                    counter.textContent = target;
                                }
                            };
                            updateCount();
                        }
                    });
                }, 500); // Wait 500ms for stats to load
            });
        </script>
        <script>

        </script>
        <script>
            // --- Upload Image Hover + File Selection + Preview ---
            function showUploadBtn(box) {
                const btn = box.querySelector('.upload-btn');
                btn.classList.remove('d-none');
            }

            function hideUploadBtn(box) {
                const btn = box.querySelector('.upload-btn');
                btn.classList.add('d-none');
            }

            function triggerFileInput(box) {
                const input = box.querySelector('.file-input');
                input.click();

                input.addEventListener('change', function() {
                    if (this.files && this.files[0]) {
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            let img = box.querySelector('img');
                            if (!img) {
                                img = document.createElement('img');
                                img.style.maxWidth = '100%';
                                img.style.maxHeight = '100%';
                                img.style.borderRadius = '10px';
                                img.style.objectFit = 'cover';
                                img.style.position = 'absolute';
                            }
                            img.src = e.target.result;
                            box.appendChild(img);
                        };
                        reader.readAsDataURL(this.files[0]);
                    }
                }, {
                    once: true
                });
            }
        </script>
    </body>

    </html>

<?php
} else {
?>
    <script>
        alert("Unautharized Access.Please Loging First!");
        window.location = "AdminLogin.php";
    </script>
<?php
}

?>
