<?php
session_start();
?>
<!DOCTYPE html>
<html lang="si">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sri Lanka’s First Digital Exam & Exam Practice Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;700&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="common.css">
    <link rel="icon" type="image/png" href="Resources/Logo/icon.png">
    <!-- AOS Animation CSS -->
    <link href="https://unpkg.com/aos@2.3.4/dist/aos.css" rel="stylesheet">


    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
        }

        .hero-section {
            background: url('Resources/Images/Hero1.png') no-repeat center center/cover;
            height: 100vh;
            position: relative;
            box-shadow: inset 0 0 0 1000px rgba(0, 0, 0, 0.3);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .hero-content-container {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            width: clamp(280px, 60%, 800px);
            gap: 1rem;
        }

        .hero-content-container h1 {
            font-size: clamp(1.2rem, 7vw, 2.5rem); /* increased size for wider screens */
            line-height: 1.2;
        }

        .hero-content-container p {
            font-size: clamp(0.8rem, 2.5vw, 1.2rem);
            line-height: 1.4;
        }

        .d-flex.gap-3 {
            flex-wrap: wrap;
            justify-content: center;
            gap: clamp(0.5rem, 2vw, 1rem);
        }

        .discover-btn,
        .btn-white {
            width: clamp(140px, 40%, 200px);
            height: clamp(40px, 5vw, 50px);
            font-size: clamp(12px, 2vw, 17px);
        }


        .discover-btn,
        .btn-white {
            width: 200px; /* same width for both buttons */
            height: 50px; /* same height for both buttons */
            padding: 0 20px;
            border-radius: 7px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: clamp(12px, 2vw, 17px); /* text size responsive */
            transition: transform 0.3s ease, box-shadow 0.3s ease, background 0.3s ease;
        }

        .discover-btn {
            background: linear-gradient(45deg, var(--primary), var(--secondary));
            color: var(--light);
        }

        .discover-btn:hover {
            background: linear-gradient(45deg, var(--secondary), var(--primary));
            transform: translateY(-3px);
        }

        .btn-white {
            background: var(--light);
            color: var(--black);
        }

        .btn-white:hover {
            background-color: #e2e6ea;
            transform: translateY(-3px);
        }



        @media (max-width: 768px) {
            .hero-content-container {
                width: 90%;
                padding-left: 1rem;
                padding-right: 1rem;
            }
        }

        /* Center hero content on lg and smaller screens */
        @media (max-width: 1199.98px) {
            .hero-content-container {
                margin: 0 auto;
                text-align: center;
                align-items: center;
                justify-content: center;
            }
        }

        /* Left-align hero content on xl screens and above */
        @media (min-width: 1200px) {
            .hero-content-container {
                margin: 0;
                text-align: left;
                align-items: flex-start;
                justify-content: center;
            }
        }



        /* 2nd Content */

        .custom-dropdown {
            position: relative;
            width: 200px;
            color: var(--black);
        }


        /* Button */
        .dropdown-btn {
            width: 100%;
            border: 2px solid var(--primary);
            border-radius: 50px;
            padding: 10px 16px;
            background-color: transparent;
            font-size: 14px;
            color: var(--black);
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .dropdown-btn:after {
            content: "\25BC";
            /* ▼ icon */
            font-size: 12px;
            margin-left: 8px;
        }

        /* Dropdown list */
        .dropdown-list {
            position: absolute;
            top: 110%;
            left: 0;
            right: 0;
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
            display: none;
            z-index: 1000;
        }

        .dropdown-list div {
            padding: 10px 16px;
            cursor: pointer;
        }

        .dropdown-list div:hover {
            background-color: #f8f9fa;
        }

        /* Active state */
        .custom-dropdown.active .dropdown-list {
            display: block;
        }

        .search-box {
            display: flex;
            align-items: center;
            border: 2px solid var(--primary);
            border-radius: 50px;
            padding: 6px 12px; /* smaller padding for reduced height */
            width: 200px;
            transition: box-shadow 0.3s ease;
            background-color: transparent;
        }

        .search-box input {
            border: none;
            outline: none;
            flex: 1;
            font-size: 14px;
            border-radius: 50px;
            background-color: transparent;
            height: 28px; /* reduced height */
        }


        .search-btn {
            border: none;
            background-color: transparent;
            margin-left: -10px;
        }

        /* Mobile size (sm and below) */
        @media (max-width: 768px) {
            .search-box {
                padding: 5px 10px;
                width: 180px;
                gap: 6px;
            }

            .search-box input {
                height: 26px; /* reduced height */
            }
        }



        .custom-card {
            border: 1px solid #dee2e6;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            cursor: pointer;
        }

        .custom-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.15);

        }


        .course-title {
            color: var(--black);
        }


        .course-image-container {
            height: 180px;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .custom-image-style {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .view-button {
            background: linear-gradient(45deg, var(--primary), var(--secondary));
            border-color: #dc3545;
            border-radius: 0.25rem;
        }

        .view-button:hover {
            background-color: #c82333;
            border-color: #bd2130;
        }


        .input-group .btn-danger {
            border-top-left-radius: 0 !important;
            border-bottom-left-radius: 0 !important;
        }

        .input-group .form-control {
            border-right: none;
        }


        .pagination {
            display: flex;
            gap: 8px;
        }

        .page-btn,
        .page-number {
            border: none;
            background: #e9e9e9ff;
            color: #333;
            padding: 8px 14px;
            font-size: 14px;
            border-radius: 6px;
            cursor: pointer;
            transition: background 0.3s ease, color 0.3s ease;
        }

        .page-btn:hover,
        .page-number:hover {
            background: #e4e4e4;
        }

        .page-number.active {
            background: linear-gradient(180deg, var(--primary), var(--secondary));
            color: #fff;
            font-weight: 600;
        }

        .page-btn {
            font-weight: 600;
        }

        /* 4th Content */


        .counter-title {
            text-align: center;
            padding: 60px 20px 20px;
        }

        .counter-title h2 {
            font-weight: 700;
        }

        .counter-title h2 span {
            color: var(--secondary);
        }

        #counter-section {
            background: #fff;
            padding: 50px 0;
            text-align: center;
        }

        .counter-box {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: var(--light);
            border-radius: 10px;
            padding: 25px 0;
            width: 110px;
            margin: 0 auto 10px;
            font-size: 1.8rem;
            font-weight: 700;
        }

        .counter-text {
            font-weight: 600;
            color: #2c3e50;
        }

        /* Left-align hero buttons on XXL screens */
        @media (min-width: 1200px) {
            .hero-content-container .d-flex.gap-3 {
                justify-content: flex-start !important;
            }
        }

        @media (max-width: 576px) {
            .hero-content-container h1 {
                font-size: 2rem !important;
                line-height: 1.3 !important;
            }
        }
        @media (max-width: 576px) {
            .hero-content-container p.lead {
                font-size: 1rem !important;
                line-height: 1.45 !important;
            }
        }
    </style>
</head>

    <!-- Responsive fix for 2nd content H2 on small screens -->
    <style>
    /* Prevent 2nd content H2 from shrinking too much on small screens */
    @media (max-width: 576px) {
        #scrollspyHeading2 h2 {
            font-size: 1.7rem !important;
            line-height: 1.3 !important;
        }
        #scrollspyHeading2 p {
            font-size: 0.9rem !important;
        }
    }
    </style>
</head>

<body onload="loadCategories(currentPage)" data-bs-spy="scroll" data-bs-target="#navbar" data-bs-offset="40" tabindex="0" style="scroll-behavior: smooth; overflow-x:hidden;"  >

    <div class="">


        <?php include "Navbar.php"; ?>

        <header class="hero-section">
            <div class="container h-100">

                <div class="row align-items-center h-100">

                    <div class="col-lg-8 col-md-9 text-white hero-content-container">
                        <h1 class="display5 fw-bold mb-3" data-aos="fade-right">
                            Master Exams with Confidence
                        </h1>

                        <div data-aos="fade-up">
                            <p class="lead  mb-4" style="text-align: justify;">
                                Eexam.lk is Sri Lanka’s First Digital Exam & Practice Platform, designed to help students experience real exam conditions through computer-based mock tests. Learn smart, reduce stress, and achieve success
                            </p>
                            <div class="d-flex gap-3">
                                <a href="#scrollspyHeading2" style="text-decoration: none;" class="discover-btn fw-bold">Discover Courses</a>
                                <a href="Dashboard.php" style="text-decoration: none;" ><button style="border: none;" class=" btn-white btn-lg px-4 fw-bold">My Courses</button> </a>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </header>


        <!-- 2nd Content -->
        <div id="scrollspyHeading2" class="py-5 container">

            <div class="text-center mb-4" data-aos="fade-up">
                <h2 class="fw-bold">Discover <span style="color: var(--secondary);">Courses</span></h2>
                <p class="col-md-12 col-lg-10 col-xl-8  mx-auto text-muted ">Choose from a wide range of practice exams and learning modules designed to match your syllabus. With instant feedback, accessible learning, and exam-style simulations, Eexam.lk makes your preparation smarter and stress-free</p>
            </div>

            <div class="row mb-5 justify-content-end">
                <div class="col-auto d-flex gap-2  custom-responsive-container">

                    <div class="custom-dropdown d-none">
                        <div class="dropdown-btn">Select Category</div>
                        <div class="dropdown-list">
                            <div data-value="1">IT</div>
                            <div data-value="2">Commerce</div>
                            <div data-value="3">Marketing</div>
                        </div>
                    </div>

                   <div class="search-box" data-aos="zoom-in" style="position: relative; width: 100%; max-width: 200px;">
                        <input onkeyup="performSearch();" type="text" placeholder="Search..." onkeyup="if(event.key === 'Enter') performSearch()" style="width: 100%; padding-right: 40px; box-sizing: border-box;">
                        <button class="search-btn" onkeyup="performSearch()" style="position: absolute; right: 5px; top: 50%; transform: translateY(-50%); border: none; background: transparent; padding: 0; margin: 0;">
                            <img src="Resources/Icons/find.png" style="height:28px; width:28px; object-fit:contain;">
                        </button>
                    </div>

                </div>
            </div>

            <div class="row d-flex justify-content-center" id="cards">



                <div class="col-10 col-md-6 col-lg-4  mb-3" data-aos="zoom-in">
                    <div class="card h-100 shadow-sm border-0 custom-card position-relative" style="opacity: 0.6; pointer-events: none;">
                        <div class="card-img-top bg-dark overflow-hidden course-image-container">
                            <img src="Resources/Images/Card-Img/It.jpg" class="img-fluid custom-image-style" alt="IT Course">
                        </div>
                        <div class="card-body p-4">
                            <h5 class="card-title fw-bold course-title text-start">IT</h5>
                            <p class="card-text text-muted small">Lorem ipsum dolor sit amet, consectetur adipiscing adipiscing consectetur adipiscing</p>
                            <div class="coming-soon-overlay" style="position: absolute; inset: 0; background: rgba(0,0,0,0.6); display: flex; align-items: center; justify-content: center; border-radius: 10px;">
                                <span style="color: white; font-size: 1.5rem; font-weight: 700;">Coming Soon</span>
                            </div>
                        </div>
                    </div>


                </div>

            </div>

            <div class="d-flex justify-content-center mt-5" data-aos="zoom-in">

                <div class="pagination">
                    <button class="page-btn">Previous</button>
                    <button class="page-number active">1</button>
                    <button class="page-number">2</button>
                    <button class="page-number">3</button>
                    <button class="page-btn">Next</button>
                </div>


            </div>



        </div>

        <!-- 3rd Content -->
        <div class="counter-title mb-4" data-aos="fade-up">
            <h2>Our <span>Achievements</span></h2>
            <p class="col-md-10 col-lg-8 col-xl-6  mx-auto text-muted ">Our digital exam platform helps students practice with confidence through real exam-style simulations, instant feedback, and accessible learning tools designed for success.</p>

        </div>

        <section id="counter-section">
            <div class="container">
                <div class="row gy-4">
                    <div class="col-12 col-md-4" data-aos="zoom-in">
                        <div class="counter-box counter" data-target="0" id="students-counter">0+</div>
                        <p class="counter-text">Registered Students</p>
                    </div>
                    <div class="col-12 col-md-4" data-aos="zoom-in">
                        <div class="counter-box counter" data-target="0" id="courses-counter">0+</div>
                        <p class="counter-text">Course Count</p>
                    </div>
                    <div class="col-12 col-md-4" data-aos="zoom-in">
                        <div class="counter-box counter" data-target="0" id="subjects-counter">0+</div>
                        <p class="counter-text">Subject Count</p>
                    </div>
                </div>
            </div>
        </section>


        <!-- 4th Content-->
        <?php include "Comment.php"; ?>

        <?php include "Footer.php"; ?>
    </div>

    <script src="Backend/Js/index.js"></script>

    <script>
        const dropdown = document.querySelector('.custom-dropdown');
        const btn = dropdown.querySelector('.dropdown-btn');
        const list = dropdown.querySelector('.dropdown-list');
        const items = list.querySelectorAll('div');

        // Toggle dropdown
        btn.addEventListener('click', () => {
            dropdown.classList.toggle('active');
        });

        // Select option
        items.forEach(item => {
            item.addEventListener('click', () => {
                btn.textContent = item.textContent;
                btn.dataset.value = item.dataset.value;
                dropdown.classList.remove('active');
                
                // Trigger search when category is selected
                performSearch();
            });
        });

        // Close on outside click
        document.addEventListener('click', (e) => {
            if (!dropdown.contains(e.target)) {
                dropdown.classList.remove('active');
            }
        });


        // Counter Animation
        const counters = document.querySelectorAll('.counter');
        let animationIntervals = [];
        let countersStarted = false;

        function animateCounters() {
            // Clear previous intervals to avoid stacking
            animationIntervals.forEach(interval => clearInterval(interval));
            animationIntervals = [];

            counters.forEach(counter => {
                counter.innerText = '0+';
                const target = +counter.getAttribute('data-target');
                const duration = 2300; // total animation time in ms
                const fps = 60;
                const steps = Math.round((duration / 1000) * fps);
                const increment = target / steps;

                let current = 0;

                const interval = setInterval(() => {
                    current += increment;
                    if (current >= target) {
                        counter.innerText = target + '+';
                        clearInterval(interval);
                    } else {
                        counter.innerText = Math.ceil(current) + '+';
                    }
                }, 1000 / fps);

                animationIntervals.push(interval);
            });
        }

        function resetCounters() {
            // Stop animations
            animationIntervals.forEach(interval => clearInterval(interval));
            animationIntervals = [];
            counters.forEach(counter => {
                counter.innerText = '0+';
            });
            countersStarted = false;
        }

        function isCounterInView() {
            const section = document.getElementById('counter-section');
            const rect = section.getBoundingClientRect();
            return rect.top < window.innerHeight && rect.bottom > 0;
        }

        // Load counts from database
        let countsLoaded = false;
        async function loadCounts() {
            try {
                const response = await fetch("Backend/Process/LoadCounts.php");
                const json = await response.json();
                
                if (json.status && json.data) {
                    // Update data-target attributes
                    const studentsCounter = document.getElementById("students-counter");
                    const coursesCounter = document.getElementById("courses-counter");
                    const subjectsCounter = document.getElementById("subjects-counter");
                    
                    if (studentsCounter) {
                        studentsCounter.setAttribute("data-target", json.data.students || 0);
                    }
                    if (coursesCounter) {
                        coursesCounter.setAttribute("data-target", json.data.courses || 0);
                    }
                    if (subjectsCounter) {
                        subjectsCounter.setAttribute("data-target", json.data.subjects || 0);
                    }
                    
                    countsLoaded = true;
                    
                    // If counter section is already in view, trigger animation
                    if (isCounterInView() && !countersStarted) {
                        animateCounters();
                        countersStarted = true;
                    }
                }
            } catch (err) {
                console.error("Error loading counts:", err);
                countsLoaded = true; // Set to true even on error to prevent blocking
            }
        }

        // Load counts on page load
        loadCounts();

        window.addEventListener('scroll', () => {
            if (isCounterInView() && !countersStarted && countsLoaded) {
                animateCounters();
                countersStarted = true;
            } else if (!isCounterInView() && countersStarted) {
                // ✅ Immediately reset when section hides even once
                resetCounters();
            }
        });
    </script>
    <script src="common.js"></script>
    <!-- AOS Animation Script -->
    <script src="https://unpkg.com/aos@2.3.4/dist/aos.js"></script>
    <script>
        AOS.init({
            duration: 1000,
            once: true,
            offset: 100,
        });
    </script>
</body>

</html>