<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
     <title>Sri Lanka’s First Digital Exam & Exam Practice Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
        <link rel="icon" type="image/png" href="Resources/Logo/icon.png">
    <!-- AOS Animation CSS -->
    <link href="https://unpkg.com/aos@2.3.4/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="common.css">

    <style>
        .left-section {
            background: url("Resources/Images/login-image.jpg") center/cover no-repeat;
            position: relative;
            min-height: 100vh;
        }

        .left-section::before {
            content: "";
            position: absolute;
            inset: 0;
            background: rgba(0, 0, 0, 0.5);
        }

        .left-text {
            position: relative;
            z-index: 2;
            margin-top: 310px;
        }

        .left-section h1 {
            font-weight: 700;
            font-size: 40px;
        }

        @media (max-width: 1140px) {
            .left-section h1 {
                font-size: 30px;
            }
        }

        .left-section .highlight {
            color: var(--primary);
        }

        .right-section {
            background: #fff;
            border-left: 8px solid var(--primary);
            min-height: 100vh;
            position: relative;
        }



        .contact-info {
            position: absolute;
            top: 15px;
            right: 30px;
            font-size: 0.9rem;
            color: var(--gray);
        }

        .login-form h3 {
            font-weight: 700;
            color: var(--secondary);
        }

        .form-control {
            border-radius: 8px;
            padding: 10px 14px;
        }

        .toggle-password {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: var(--secondary);
        }

        input[type="checkbox"]:checked {
            accent-color: var(--primary);
        }

        .login-btn {
            height: 50px;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            border: none;
            border-radius: 8px;
            font-weight: 600;
            color: var(--light);
        }

        .login-btn:hover {
            background: linear-gradient(135deg, var(--secondary), var(--primary));
            color: var(--light);
            transform: translateY(-3px);
            transition: all 0.3s;
        }

        .login-link {
            color: var(--primary);
            font-weight: 500;
            text-decoration: none;
        }

        .login-link:hover {
            text-decoration: underline;
        }

        @media (max-width: 991px) {
            .left-section {
                display: none;
            }

            .right-section {
                border: none;
            }
        }

        /* Mobile Optimization for Login Page */
        @media (max-width: 577px) {
            body {
                overflow-x: hidden;
            }

            .right-section {
                padding: 20px !important;
            }

            .login-form {
                width: 100% !important;
                margin: 0 auto !important;
            }

            .login-form h3 {
                font-size: 24px !important;
            }

            .login-form p.text-muted {
                font-size: 14px !important;
            }

            .form-control {
                font-size: 14px !important;
                padding: 10px 12px !important;
            }

            .login-btn {
                font-size: 14px !important;
                padding: 10px 0 !important;
            }

            .contact-info {
              
                top: 10px !important;
                right: 10px !important;
                font-size: 12px !important;
            }

            .left-section {
                display: none !important;
            }

            .left-text h1 {
                font-size: 28px !important;
            }

            .left-text p {
                font-size: 14px !important;
            }
        }
    </style>
</head>

<body style="overflow-x: hidden;">

    <div class="container-fluid min-vh-100">
        <div class="row h-100">

            <!-- Left Section -->
            <div class="col-lg-6 d-none d-lg-flex align-items-center justify-content-center left-section">

                <div class="text-white text-center px-4 left-text " data-aos="fade-right">
                    <h1>Welcome to <span style="color: var(--secondary);"><img src="Resources/Logo/Logo.png" class="mb-2" style="height: 50px;"></span></h1>
                    <p class="text-start">Transforms lives through education</p>
                </div>
            </div>

            <!-- Right Section -->
            <div class="col-lg-6 d-flex flex-column justify-content-center px-5 py-4 right-section">

                <!-- Top Contact Info -->
                <div class="d-flex justify-content-end contact-info">

    <!-- Gmail Click → Opens Gmail Compose -->
    <span class="me-3">
        <img src="Resources/Icons/email.png" style="height: 18px;">
        <a href="https://mail.google.com/mail/?view=cm&fs=1&to=team.eexam@gmail.com" 
           target="_blank" 
           style="text-decoration:none; color:inherit;">
            team.eexam@gmail.com
        </a>
    </span>

    <!-- WhatsApp Click → Opens Chat -->
    <span>
        <img src="Resources/Icons/hotline.png" style="height: 18px;">
        <a href="https://wa.me/94753595844" 
           target="_blank" 
           style="text-decoration:none; color:inherit;">
            075 359 5844
        </a>
    </span>

</div>

                <!-- Login Form -->
                <div class="login-form">
                    <div>
                        <div class="row col-md-10 col-12 col-lg-12 col-xl-10 g-3 mx-auto mt-5 " data-aos="fade-up">
                            <div class="container">
                                <h3 class="mb-2">Student Login</h3>
                                <p class="text-muted mb-4">Enter your credentials to continue</p>
                            </div>

                            <?php
                            $email = "";
                            $password = "";
                            $rememberChecked = "";

                            if (isset($_COOKIE["user_email"]) && isset($_COOKIE["user_password"])) {
                                $email = htmlspecialchars($_COOKIE["user_email"]);
                                $password = htmlspecialchars($_COOKIE["user_password"]);
                                $rememberChecked = "checked";
                            }
                            ?>

                            <!-- Email Address -->
                            <div class="mt-2">
                                <label for="form-label" class="mb-1 fw-bold">Email Address</label>
                                <input id="email" type="text" class="form-control" placeholder="john.smith@example.com" value="<?php echo $email; ?>">
                            </div>

                            <!-- Password -->
                            <div class="mt-3 position-relative">
                                <label for="form-label" class="mb-1 fw-bold">Password</label>
                                <input id="password" type="password" class="form-control" id="password" placeholder="J0hn$mith2025!" value="<?php echo $password; ?>">
                                <i class="fa-solid fa-eye toggle-password me-3 mt-3" id="togglePassword"></i>
                            </div>

                            <!-- Remember & Forgot -->
                            <div class="d-flex justify-content-between align-items-center mt-3">
                                <div>
                                    <input type="checkbox" id="remember" <?php echo $rememberChecked; ?>>
                                    <label for="remember">Remember me</label>
                                </div>
                                <a onclick="forgotPassword();" href="#" class="login-link">Forgot Password?</a>
                            </div>

                            <!-- Button -->
                            <div class="d-grid">
                                <button onclick="signIn(event);" class="btn login-btn mt-4">
                                    <img class="me-2" src="Resources/Icons/login.png" style="height: 30px;">Login to Dashboard
                                </button>
                            </div>

                            <!-- Register Link -->
                            <p class="mt-3 text-start">
                                Are you new student? <a href="Register.php" class="login-link">Register here</a>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Reset Password Modal -->
    <div class="modal fade" id="resetPasswordModal" tabindex="-1" aria-labelledby="resetPasswordModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content" style="border-radius: 15px; border: none; box-shadow: 0 10px 40px rgba(0,0,0,0.15);">
                <div class="modal-header border-0 pb-0" style="background: linear-gradient(135deg, var(--primary), var(--secondary)); border-radius: 15px 15px 0 0; padding: 25px 30px;">
                    <h5 class="modal-title text-white fw-bold" id="resetPasswordModalLabel">
                        <i class="fa-solid fa-key me-2"></i>Reset Password
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                    <p class="text-muted mb-4">Enter the verification code sent to your email and create a new password.</p>
                    
                    <form id="resetPasswordForm">
                        <!-- Verification Code -->
                        <div class="mb-3">
                            <label for="verificationCode" class="form-label fw-bold mb-2">
                                <i class="fa-solid fa-shield-halved me-2 text-primary"></i>Verification Code
                            </label>
                            <input type="text" class="form-control form-control-lg" id="verificationCode" 
                                   placeholder="Enter 5-digit code" maxlength="5" 
                                   style="border: 2px solid #e0e0e0; border-radius: 10px; padding: 12px 15px; font-size: 18px; letter-spacing: 3px; text-align: center;"
                                   oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                            <small class="text-muted mt-1 d-block">
                                <i class="fa-solid fa-envelope me-1"></i>Check your email for the verification code
                            </small>
                        </div>

                        <!-- New Password -->
                        <div class="mb-3 position-relative">
                            <label for="newPassword" class="form-label fw-bold mb-2">
                                <i class="fa-solid fa-lock me-2 text-primary"></i>New Password
                            </label>
                            <input type="password" class="form-control form-control-lg" id="newPassword" 
                                   placeholder="Enter new password" 
                                   style="border: 2px solid #e0e0e0; border-radius: 10px; padding: 12px 45px 12px 15px;">
                            <i class="fa-solid fa-eye toggle-password-reset" id="toggleNewPassword" 
                               style="position: absolute; right: 15px; top: 42px; cursor: pointer; color: var(--secondary); font-size: 18px;"></i>
                            <div class="password-strength mt-2" id="passwordStrength" style="display: none;">
                                <div class="progress" style="height: 5px; border-radius: 10px;">
                                    <div class="progress-bar" role="progressbar" style="width: 0%; transition: all 0.3s;"></div>
                                </div>
                                <small class="text-muted mt-1 d-block" id="passwordStrengthText"></small>
                            </div>
                        </div>

                        <!-- Confirm Password -->
                        <div class="mb-4 position-relative">
                            <label for="confirmPassword" class="form-label fw-bold mb-2">
                                <i class="fa-solid fa-lock me-2 text-primary"></i>Confirm Password
                            </label>
                            <input type="password" class="form-control form-control-lg" id="confirmPassword" 
                                   placeholder="Confirm new password" 
                                   style="border: 2px solid #e0e0e0; border-radius: 10px; padding: 12px 45px 12px 15px;">
                            <i class="fa-solid fa-eye toggle-password-reset" id="toggleConfirmPassword" 
                               style="position: absolute; right: 15px; top: 42px; cursor: pointer; color: var(--secondary); font-size: 18px;"></i>
                            <div class="password-match mt-2" id="passwordMatch" style="display: none;">
                                <small class="d-block" id="passwordMatchText"></small>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="d-grid">
                            <button type="button" class="btn btn-lg text-white fw-bold" 
                                    onclick="resetPassword();" 
                                    style="background: linear-gradient(135deg, var(--primary), var(--secondary)); border-radius: 10px; padding: 12px; height: 50px;">
                                <i class="fa-solid fa-check-circle me-2"></i>Reset Password
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="common.js"></script>
    <script src="Backend/Js/SignIn.js"></script>
    <script src="Backend/Js/forgotPassword.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- AOS Animation Script -->
    <script src="https://unpkg.com/aos@2.3.4/dist/aos.js"></script>
    <script>
        AOS.init({
            duration: 800,
            once: true,
            offset: 80,
        });
    </script>
</body>

</html>